---
generated_at: 2026-01-29 21:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-SEOメタデータ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/general/seo-meta.tsx` - メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 親コンポーネント
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネント名は SEOMeta | E-01 (L63) | ○ |
| C-02 | useSettingGroupフックを使用 | E-01 (L64-74) | ○ |
| C-03 | useUploadImageフックを使用 | E-01 (L77) | ○ |
| C-04 | usePinturaEditorフックを使用 | E-01 (L78) | ○ |
| C-05 | getSettingValuesで10個の設定値を取得 | E-01 (L81-103) | ○ |
| C-06 | SearchEnginePreviewコンポーネント | E-01 (L18-61) | ○ |
| C-07 | TabViewで3つのタブ | E-01 (L299-315, L331-336) | ○ |
| C-08 | metadataタブID、Searchタイトル | E-01 (L300-303) | ○ |
| C-09 | twitterタブID、X cardタイトル | E-01 (L304-308) | ○ |
| C-10 | facebookタブID、Facebook cardタイトル | E-01 (L309-313) | ○ |
| C-11 | Meta titleのmaxLength 300 | E-01 (L161) | ○ |
| C-12 | Meta descriptionのmaxLength 500 | E-01 (L169) | ○ |
| C-13 | Meta titleヒント "Recommended: 70 characters" | E-01 (L159) | ○ |
| C-14 | Meta descriptionヒント "Recommended: 156 characters" | E-01 (L168) | ○ |
| C-15 | createSettingHandlerでハンドラー生成 | E-01 (L108-113) | ○ |
| C-16 | createImageUploadHandlerでアップロードハンドラー | E-01 (L115-129) | ○ |
| C-17 | createImageDeleteHandlerで削除ハンドラー | E-01 (L131-136) | ○ |
| C-18 | og_imageのImageUpload | E-01 (L200-221) | ○ |
| C-19 | twitter_imageのImageUpload | E-01 (L256-277) | ○ |
| C-20 | Pintura統合（isEnabled, openEditor） | E-01 (L205-215, L261-271) | ○ |
| C-21 | プレースホルダーにsiteTitle使用 | E-01 (L162, L225, L281) | ○ |
| C-22 | プレースホルダーにsiteDescription使用 | E-01 (L170, L233, L289) | ○ |
| C-23 | TopLevelGroupでラップ | E-01 (L317-337) | ○ |
| C-24 | hideEditButton プロパティあり | E-01 (L326) | ○ |
| C-25 | navid='metadata' | E-01 (L322) | ○ |
| C-26 | title='Meta data' | E-01 (L325) | ○ |
| C-27 | HTTP 415エラー時のメッセージ設定 | E-01 (L124-126) | ○ |
| C-28 | 関連機能No.38 SEO設定 | E-03 (L66) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての技術仕様がソースコードから直接確認済み
- **0: 低リスク** - 入力フィールドの制限値が明確に定義されている

## 6) レビュアーチェックリスト（最小）

- [ ] 各タブで正しいフィールドが表示されることを確認
- [ ] SearchEnginePreviewがリアルタイムで更新されることを確認
- [ ] 画像アップロードが正常に動作することを確認
- [ ] Pinturaエディタ（有効時）で画像編集ができることを確認
- [ ] 保存後に設定が反映されることを確認
