---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-ソーシャルアカウント設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/general/social-accounts.tsx` - メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 親コンポーネント
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネント名は SocialAccounts | E-01 (L8) | ○ |
| C-02 | useSettingGroupフックを使用 | E-01 (L9-17) | ○ |
| C-03 | errorsのuseState | E-01 (L19-22) | ○ |
| C-04 | getSettingValuesでfacebook, twitter取得 | E-01 (L24) | ○ |
| C-05 | facebookUrl, twitterUrlのuseState | E-01 (L26-27) | ○ |
| C-06 | facebookHandleToUrl/twitterHandleToUrl使用 | E-01 (L5, L26-27) | ○ |
| C-07 | useEffectでキャンセル時リセット | E-01 (L30-33) | ○ |
| C-08 | handleFacebookChangeでFacebook処理 | E-01 (L35-52) | ○ |
| C-09 | validateFacebookUrlでバリデーション | E-01 (L38) | ○ |
| C-10 | facebookUrlToHandleでハンドル抽出 | E-01 (L39) | ○ |
| C-11 | updateSetting('facebook', ...)呼び出し | E-01 (L39, L50) | ○ |
| C-12 | handleTwitterChangeでX処理 | E-01 (L54-71) | ○ |
| C-13 | validateTwitterUrlでバリデーション | E-01 (L57) | ○ |
| C-14 | twitterUrlToHandleでハンドル抽出 | E-01 (L58) | ○ |
| C-15 | handleSaveClickで保存前バリデーション | E-01 (L73-104) | ○ |
| C-16 | TopLevelGroupでラップ | E-01 (L106-139) | ○ |
| C-17 | hideEditButton プロパティあり | E-01 (L115) | ○ |
| C-18 | navid='social-accounts' | E-01 (L111) | ○ |
| C-19 | title='Social accounts' | E-01 (L114) | ○ |
| C-20 | Facebook URLプレースホルダー | E-01 (L124) | ○ |
| C-21 | X URLプレースホルダー | E-01 (L132) | ○ |
| C-22 | 関連機能No.36 ソーシャルメディア連携 | E-03 (L67) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての技術仕様がソースコードから直接確認済み
- **0: 低リスク** - バリデーションロジックが明確に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] 有効なFacebook URLの入力が成功することを確認
- [ ] 有効なX URLの入力が成功することを確認
- [ ] 無効なURL入力時にエラーメッセージが表示されることを確認
- [ ] キャンセル時にURLがリセットされることを確認
- [ ] 保存後にハンドル形式で保存されることを確認
