---
generated_at: 2026-01-29 21:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-サイトロック設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/general/lock-site.tsx` - メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/general/general-settings.tsx` - 親コンポーネント
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネント名は LockSite | E-01 (L8) | ○ |
| C-02 | useGlobalDataでsiteData取得 | E-01 (L6, L9) | ○ |
| C-03 | useSettingGroupフックを使用 | E-01 (L10-30) | ○ |
| C-04 | onValidateでパスワード必須チェック | E-01 (L21-29) | ○ |
| C-05 | getSettingValuesでis_private, password, public_hash取得 | E-01 (L32) | ○ |
| C-06 | handleToggleChangeでis_private更新 | E-01 (L34-36) | ○ |
| C-07 | handlePasswordChangeでpassword更新 | E-01 (L38-40) | ○ |
| C-08 | privateRssUrl = siteUrl + publicHash + '/rss' | E-01 (L42) | ○ |
| C-09 | 表示モード: 保護有効時のIcon lock-locked | E-01 (L56) | ○ |
| C-10 | 表示モード: 保護無効時のIcon lock-unlocked | E-01 (L69) | ○ |
| C-11 | "Your site is password protected"メッセージ | E-01 (L59) | ○ |
| C-12 | "Your site is not password protected"メッセージ | E-01 (L70) | ○ |
| C-13 | プライベートRSSフィードのHint表示 | E-01 (L43-45, L62-65) | ○ |
| C-14 | 編集モード: Toggleコンポーネント | E-01 (L80-86) | ○ |
| C-15 | Toggleヒント "All search engine optimization..." | E-01 (L83) | ○ |
| C-16 | 編集モード: TextField（保護有効時のみ） | E-01 (L87-98) | ○ |
| C-17 | "Enter a password"バリデーションエラー | E-01 (L24) | ○ |
| C-18 | TopLevelGroupでラップ | E-01 (L102-117) | ○ |
| C-19 | navid='locksite' | E-01 (L107) | ○ |
| C-20 | title='Make site private' | E-01 (L110) | ○ |
| C-21 | isEditingで表示/編集モード切り替え | E-01 (L115) | ○ |
| C-22 | 関連機能No.35 一般設定 | E-03 (L68) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張がソースコードから確認可能）

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 全ての技術仕様がソースコードから直接確認済み
- **0: 低リスク** - バリデーションロジックが明確に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] パスワード保護有効化でSEO機能が無効になることを確認
- [ ] パスワード未入力で保存時にエラーが表示されることを確認
- [ ] プライベートRSSフィードURLが正しく生成されることを確認
- [ ] パスワード保護解除後にサイトにアクセス可能になることを確認
- [ ] 表示モードと編集モードの切り替えが正常に動作することを確認
