---
generated_at: 2026-01-29 20:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-パスワードリセット画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/reset.hbs` - パスワードリセットフォームテンプレート
- E-02: `ghost/admin/app/routes/reset.js` - リセットルート定義
- E-03: `ghost/admin/app/controllers/reset.js` - リセットコントローラー
- E-04: `ghost/admin/app/validators/reset.js` - リセットバリデータ
- E-05: `ghost/admin/app/validators/mixins/password.js` - パスワードバリデーションミックスイン
- E-06: `ghost/core/core/server/api/endpoints/authentication.js` - 認証APIエンドポイント
- E-07: `ghost/core/core/server/services/auth/passwordreset.js` - パスワードリセットサービス
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワードリセットメールリンク経由でアクセス | E-02 (16-18行目: params.token) | ○ |
| C-02 | URL: /ghost/reset/:token | E-02, E-08 | ○ |
| C-03 | 新しいパスワードとパスワード確認を入力 | E-01 (9-39行目) | ○ |
| C-04 | パスワード必須チェック | E-04 (16-18行目) | ○ |
| C-05 | パスワード一致チェック | E-04 (19-22行目) | ○ |
| C-06 | パスワード10文字以上 | E-05 (67-70行目) | ○ |
| C-07 | パスワード複雑性チェック | E-05 (4-112行目), E-04 (24行目) | ○ |
| C-08 | PUT /authentication/password_resetでリセット | E-03 (60-64行目), E-06 (147-172行目) | ○ |
| C-09 | リセット成功後に自動ログイン | E-03 (71行目) | ○ |
| C-10 | emailVerificationTokenで2FA検証バイパス | E-03 (60行目, 71行目), E-07 (151-154行目) | ○ |
| C-11 | トークン有効期限1日 | E-07 (52-53行目: moment().add(1, 'days')) | ○ |
| C-12 | ブルートフォース保護（10回以上でロック） | E-07 (85-94行目) | ○ |
| C-13 | usersテーブルのpassword更新 | E-07 (140-144行目: changePassword) | ○ |
| C-14 | usersテーブルのstatus更新 | E-07 (147-148行目: set('status', 'active')) | ○ |
| C-15 | トークン有効期限切れエラー | E-07 (123-128行目: expired) | ○ |
| C-16 | トークン使用済みエラー | E-07 (129-135行目) | ○ |
| C-17 | トークン不正エラー | E-07 (74-79行目: corruptedToken) | ○ |
| C-18 | ログイン済み時に警告表示 | E-02 (9-11行目) | ○ |
| C-19 | deactivateで機密情報クリア | E-02 (21-24行目), E-03 (32-38行目) | ○ |
| C-20 | トークンからメールアドレス抽出 | E-03 (25-29行目: atob, split) | ○ |
| C-21 | 入力時にエラー状態クリア | E-03 (40-47行目: handleInput) | ○ |
| C-22 | トークンはパスワードハッシュとDB hashで生成 | E-07 (52-57行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：入出力項目・バリデーション - コードから明確に確認可能
- **0（低リスク）**：画面遷移 - ルート・コントローラーから確認可能
- **0（低リスク）**：エラーメッセージ - バリデータ・サービスから確認可能
- **0（低リスク）**：DB更新仕様 - passwordreset.jsから確認可能
- **0（低リスク）**：トークン処理 - passwordreset.jsから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] トークン有効期限（1日）が適切か確認
- [ ] ブルートフォース保護の閾値（10回）が適切か確認
- [ ] パスワード変更後のトークン無効化が正しく動作するか確認
- [ ] 2FA検証バイパストークンの有効期限を確認
- [ ] 機密情報クリア（deactivate）が確実に動作するか確認
