---
generated_at: 2026-01-29 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：41-テーマ変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認
  2. **データベース更新仕様**：settingsテーブルへの更新はAPIを通じた間接的な処理

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/site/change-theme.tsx` (1-71行目)
- E-02: `apps/admin-x-framework/src/api/themes.ts` (1-158行目)
- E-03: `apps/admin-x-settings/src/components/settings/site/theme/official-themes.tsx` (1-118行目)
- E-04: `apps/admin-x-settings/src/components/settings/site/theme/theme-preview.tsx` (1-169行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (41行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (70行目)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (145-149行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーマ変更画面はサイトのビジュアルデザインを決定するテーマの選択・インストール・切り替えを行う | E-01, E-02 | ○ |
| C-02 | 画面へのアクセスはSettings→Site→Themeカードから | E-01 (navid='theme') | ○ |
| C-03 | URLは/ghost/#/settings/design/change-theme | E-01 (40行目 updateRoute) | ○ |
| C-04 | 現在アクティブなテーマ名とバージョンが表示される | E-01 (44-53行目) | ○ |
| C-05 | useBrowseThemesでテーマ一覧を取得 | E-02 (50-53行目) | ○ |
| C-06 | テーマ制限チェックはuseCheckThemeLimitErrorで実行 | E-01 (12行目) | ○ |
| C-07 | 制限エラー時はLimitModalを表示 | E-01 (35-38行目) | ○ |
| C-08 | 公式テーマはOfficialThemesコンポーネントで表示 | E-03 | ○ |
| C-09 | テーマプレビューはiframeで外部URLを読み込む | E-04 (148-161行目) | ○ |
| C-10 | デスクトップ/モバイルプレビュー切り替えが可能 | E-04 (113-132行目) | ○ |
| C-11 | useActivateThemeでテーマを有効化 | E-02 (60-82行目) | ○ |
| C-12 | useInstallThemeでGitHubからインストール | E-02 (97-113行目) | ○ |
| C-13 | useUploadThemeでZIPアップロード | E-02 (115-135行目) | ○ |
| C-14 | useDeleteThemeでテーマ削除 | E-02 (84-95行目) | ○ |
| C-15 | デフォルトテーマSource/Casperは削除不可 | E-02 (143-157行目 isDefaultOrLegacyTheme) | ○ |
| C-16 | テーマバリアントは3秒間隔で自動ループ | E-03 (7行目 VARIANT_LOOP_INTERVAL) | ○ |
| C-17 | Ghost Marketplaceへの外部リンクが提供される | E-03 (106-112行目) | ○ |
| C-18 | テーマにバリアントがある場合ドロップダウンで切り替え可能 | E-04 (91-107行目) | ○ |
| C-19 | インストールボタンのラベルは状態により変化 | E-04 (62-70行目) | ○ |
| C-20 | テーマ有効化時にカスタムテーマ設定キャッシュを無効化 | E-02 (79-81行目 invalidateQueries) | ○ |
| C-21 | GScanによるテーマ検証エラー/警告表示 | E-02 (21-36行目 ThemeProblem型) | ○ |
| C-22 | 関連機能はテーマ管理（No.30） | E-06 | ○ |
| C-23 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |
| C-24 | settingsテーブルのactive_theme設定が更新される | E-02 (間接的) | △ |
| C-25 | 画面遷移図でthemeからdesignへの遷移が定義されている | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、テーマ変更画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

- **データベース更新の詳細**: APIレスポンスの処理は確認できるが、サーバーサイドでのDB更新処理は本調査範囲外
  - 候補：`ghost/core/core/server/api/` / `ghost/core/core/server/services/themes/`

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |
| DB仕様 | サーバーサイド処理の詳細が未確認 | 0: 低リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] テーマインストール/有効化時のエラーハンドリングが適切か確認
- [ ] Ghost(Pro)プラン制限の動作が正しいか確認
- [ ] settingsテーブルへの更新処理がサーバーサイドで適切に実装されているか確認
