---
generated_at: 2026-01-29 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：42-ナビゲーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/site/navigation.tsx` (1-25行目)
- E-02: `apps/admin-x-settings/src/components/settings/site/navigation-modal.tsx` (1-85行目)
- E-03: `apps/admin-x-settings/src/hooks/site/use-navigation-editor.tsx` (1-127行目)
- E-04: `apps/admin-x-settings/src/components/settings/site/navigation/navigation-edit-form.tsx` (1-43行目)
- E-05: `apps/admin-x-settings/src/components/settings/site/navigation/navigation-item-editor.tsx` (1-78行目)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` (42行目)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (71行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ナビゲーション設定画面はプライマリとセカンダリナビゲーションの管理を行う | E-02 (21-36行目) | ○ |
| C-02 | 画面へのアクセスはSettings→Site→Navigationカードから | E-01 (navid='navigation') | ○ |
| C-03 | URLは/ghost/#/settings/navigation/edit | E-01 (9行目 updateRoute) | ○ |
| C-04 | Primary/Secondaryタブで切り替え可能 | E-02 (63-78行目 TabView) | ○ |
| C-05 | 項目はラベルとURLで構成される | E-03 (4-7行目 NavigationItem型) | ○ |
| C-06 | useNavigationEditorフックで編集ロジックを管理 | E-03 (25-124行目) | ○ |
| C-07 | ラベルが空の場合「You must specify a label」エラー | E-03 (43-45行目) | ○ |
| C-08 | 無効なURLの場合「You must specify a valid URL or relative path」エラー | E-03 (47-49行目) | ○ |
| C-09 | ドラッグ＆ドロップによる並び替えが可能 | E-04 (11-24行目 SortableList) | ○ |
| C-10 | 新規項目のデフォルトURLは「/」 | E-03 (34行目 blank: {url: '/'}) | ○ |
| C-11 | 保存時に全項目のバリデーションを実行 | E-02 (55行目), E-03 (100-122行目) | ○ |
| C-12 | navigation設定はJSON形式で保存 | E-02 (29行目 JSON.stringify) | ○ |
| C-13 | secondary_navigation設定もJSON形式で保存 | E-02 (35行目 JSON.stringify) | ○ |
| C-14 | URLはスキーム、スラッシュ、ハッシュで始まる場合有効 | E-03 (38行目 urlRegex) | ○ |
| C-15 | 削除はゴミ箱アイコンで実行 | E-04 (16行目 icon="trash") | ○ |
| C-16 | Enterキーで項目追加が可能 | E-05 (35-37行目) | ○ |
| C-17 | NavigationItemEditorで個別項目を編集 | E-05 | ○ |
| C-18 | モーダルはLargeサイズで表示 | E-02 (50行目 size='lg') | ○ |
| C-19 | 保存中は「Saving...」と表示 | E-02 (48行目) | ○ |
| C-20 | 関連機能は一般設定（No.35） | E-07 | ○ |
| C-21 | URLTextField使用でベースURL相対パスをサポート | E-05 (45-70行目) | ○ |
| C-22 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、ナビゲーション設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] バリデーションエラーの表示が適切か確認
- [ ] ドラッグ＆ドロップの動作が正しいか確認
- [ ] JSON形式での保存が正しく行われているか確認
