---
generated_at: 2026-01-29 10:40:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：43-アナウンスバー設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/site/announcement-bar.tsx` (1-25行目)
- E-02: `apps/admin-x-settings/src/components/settings/site/announcement-bar-modal.tsx` (1-228行目)
- E-03: `apps/admin-x-settings/src/components/settings/site/announcement-bar/announcement-bar-preview.tsx` (1-85行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (43行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (72行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アナウンスバー設定画面はサイト上部のお知らせバーの設定を行う | E-02 | ○ |
| C-02 | 画面へのアクセスはSettings→Site→Announcement barカードから | E-01 (navid='announcement-bar') | ○ |
| C-03 | URLは/ghost/#/settings/announcement-bar/edit | E-01 (9行目 updateRoute) | ○ |
| C-04 | 背景色の選択肢はDark/Light/Accent | E-02 (76-91行目) | ○ |
| C-05 | 表示対象はPublic visitors/Free members/Paid members | E-02 (36-61行目) | ○ |
| C-06 | テキスト入力は500msのdebounceを適用 | E-02 (137-141行目) | ○ |
| C-07 | announcement_content設定でテキストを保存 | E-02 (114, 139行目) | ○ |
| C-08 | announcement_background設定で背景色を保存 | E-02 (116, 124行目) | ○ |
| C-09 | announcement_visibility設定で表示対象を保存 | E-02 (117, 134行目) | ○ |
| C-10 | プレビューはHomepageとPostで切り替え可能 | E-02 (166-172行目) | ○ |
| C-11 | Postプレビューは最新の公開記事を使用 | E-02 (157-164行目) | ○ |
| C-12 | プレビューはiframeを使用 | E-03 (72-80行目) | ○ |
| C-13 | x-ghost-previewヘッダーでプレビューデータを送信 | E-03 (34-35行目) | ○ |
| C-14 | 有料会員オプションはpaid_members_enabled=trueの場合のみ表示 | E-02 (53-60行目) | ○ |
| C-15 | HtmlFieldでリッチテキスト編集 | E-02 (65-72行目) | ○ |
| C-16 | ColorIndicatorで背景色選択 | E-02 (73-102行目) | ○ |
| C-17 | CheckboxGroupで表示対象選択 | E-02 (103-106行目) | ○ |
| C-18 | 保存失敗時はエラートーストを表示 | E-02 (217-220行目) | ○ |
| C-19 | IframeBufferingでスムーズなプレビュー更新 | E-03 (72-80行目) | ○ |
| C-20 | visibility設定はJSON配列形式で保存 | E-02 (119, 134行目) | ○ |
| C-21 | デスクトップ/モバイルプレビュー切り替えが可能 | E-02 (203行目 deviceSelector={true}) | ○ |
| C-22 | 関連機能はアナウンスメントバー（No.39） | E-05 | ○ |
| C-23 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、アナウンスバー設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] プレビューiframeのセキュリティが適切か確認
- [ ] debounceによるテキスト更新が正しく動作するか確認
- [ ] 表示対象の組み合わせが正しく機能するか確認
