---
generated_at: 2026-01-29 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：44-アクセス設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/membership/access.tsx` (1-196行目)
- E-02: `apps/admin-x-framework/src/api/settings.ts` (1-117行目)
- E-03: `apps/admin-x-framework/src/api/tiers.ts` (1-92行目)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (44行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (73-74行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセス設定画面はサインアップ権限、デフォルトアクセス、コメント設定を管理 | E-01 (84-86行目) | ○ |
| C-02 | 画面へのアクセスはSettings→Membership→Accessカードから | E-01 (navid='members') | ○ |
| C-03 | サブスクリプションアクセスの選択肢はall/paid/invite/none | E-01 (9-30行目) | ○ |
| C-04 | デフォルトアクセスの選択肢はpublic/members/paid/tiers | E-01 (32-53行目) | ○ |
| C-05 | コメント権限の選択肢はall/paid/off | E-01 (55-71行目) | ○ |
| C-06 | members_signup_access設定でサインアップ権限を保存 | E-01 (119行目) | ○ |
| C-07 | default_content_visibility設定でデフォルトアクセスを保存 | E-01 (134行目) | ○ |
| C-08 | default_content_visibility_tiers設定でティアを保存 | E-01 (106行目) | ○ |
| C-09 | comments_enabled設定でコメント権限を保存 | E-01 (167行目) | ○ |
| C-10 | 特定ティア選択時にMultiSelectが表示される | E-01 (140-156行目) | ○ |
| C-11 | ティアはアクティブとアーカイブでグループ分けされる | E-01 (90-99行目) | ○ |
| C-12 | useBrowseTiersでティア一覧を取得 | E-01 (88行目) | ○ |
| C-13 | useSettingGroupでローカル設定を管理 | E-01 (74-82行目) | ○ |
| C-14 | ティア選択はJSON配列形式で保存 | E-01 (101, 106行目) | ○ |
| C-15 | handleEditingChangeで編集モードを開始 | E-01 (120, 135行目) | ○ |
| C-16 | hideEditButton=trueで編集ボタン非表示 | E-01 (185行目) | ○ |
| C-17 | Separatorで設定項目を区切る | E-01 (125, 157行目) | ○ |
| C-18 | 各オプションにhint（説明テキスト）が表示される | E-01 (11-14行目など) | ○ |
| C-19 | handleSaveで設定を保存 | E-01 (78, 188行目) | ○ |
| C-20 | handleCancelで変更を破棄 | E-01 (79, 186行目) | ○ |
| C-21 | 関連機能は一般設定（No.35）とメンバー登録（No.8） | E-05 | ○ |
| C-22 | SettingGroupContentでフォームレイアウトを構成 | E-01 (110行目) | ○ |
| C-23 | testId='access'でテスト識別子を設定 | E-01 (183行目) | ○ |
| C-24 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、アクセス設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] 「Nobody」設定時の影響範囲が正しく伝わるか確認
- [ ] ティア選択のグループ分けが正しく機能するか確認
- [ ] JSON形式での保存が正しく行われているか確認
