---
generated_at: 2026-01-29 10:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：45-ティア設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認
  2. **無料トライアルの適用条件**：年額のみという制約の実装詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/membership/tiers.tsx` (1-109行目)
- E-02: `apps/admin-x-settings/src/components/settings/membership/tiers/tier-detail-modal.tsx` (1-374行目)
- E-03: `apps/admin-x-framework/src/api/tiers.ts` (1-92行目)
- E-04: `apps/admin-x-framework/src/api/settings.ts` (105-116行目)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (45行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (75-76行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ティア設定画面は有料プランの作成・編集・価格設定を行う | E-02 | ○ |
| C-02 | 画面へのアクセスはSettings→Membership→Tiersカードから | E-01 (navid='tiers') | ○ |
| C-03 | Stripe接続がないと有料ティア機能が制限される | E-01 (71-76行目) | ○ |
| C-04 | useBrowseTiersでティア一覧を取得 | E-01 (29行目), E-03 (34-52行目) | ○ |
| C-05 | getActiveTiers/getArchivedTiersでティアを分類 | E-01 (30-31行目), E-03 (75-91行目) | ○ |
| C-06 | ティアは月額価格でソートされる | E-01 (54-56行目) | ○ |
| C-07 | TabViewでActive/Archivedを切り替え | E-01 (58-69行目, 73行目) | ○ |
| C-08 | checkStripeEnabledでStripe状態を判定 | E-01 (72行目), E-04 (105-116行目) | ○ |
| C-09 | useLimiterでStripe接続制限をチェック | E-01 (33, 38-49行目) | ○ |
| C-10 | TierDetailModalでティア詳細を編集 | E-02 | ○ |
| C-11 | useFormフックでフォーム管理 | E-02 (35-97行目) | ○ |
| C-12 | バリデーションで名前必須、価格検証 | E-02 (29-33行目) | ○ |
| C-13 | useAddTierで新規ティア作成 | E-02 (21行目), E-03 (54-60行目) | ○ |
| C-14 | useEditTierでティア更新 | E-02 (20行目), E-03 (62-71行目) | ○ |
| C-15 | 無料ティア可視性変更時にportal_plans設定も更新 | E-02 (70-94行目) | ○ |
| C-16 | アーカイブ/再有効化の確認モーダル | E-02 (127-154行目) | ○ |
| C-17 | 特典（Benefits）はSortableListで並び替え可能 | E-02 (99-104行目, 298-312行目) | ○ |
| C-18 | 無料トライアルはToggleで有効化 | E-02 (106-114行目, 266行目) | ○ |
| C-19 | URLTextFieldでウェルカムページURLを設定 | E-02 (283-293行目) | ○ |
| C-20 | CurrencyFieldで価格入力 | E-02 (238-261行目) | ○ |
| C-21 | 通貨選択はcurrencySelectGroupsで提供 | E-02 (228-234行目) | ○ |
| C-22 | 無料ティアは削除不可 | E-02 (158行目 type !== 'free') | ○ |
| C-23 | fetchNextPageで追加ティアを読み込み | E-01 (99-103行目) | ○ |
| C-24 | StripeConnectedButtonとStripeButto nで接続状態を表示 | E-01 (13-24行目, 80-95行目) | ○ |
| C-25 | 関連機能はTier管理（No.15）とStripe連携（No.14） | E-06 | ○ |
| C-26 | 無料ティアはtype='free'で識別 | E-01 (75行目), E-02 (17行目) | ○ |
| C-27 | 無料トライアルは年額プランにのみ適用 | **根拠なし** | △ |
| C-28 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、ティア設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

- **無料トライアルの適用条件**: ドキュメント上で「年額のみ」と記載したが、コード上では月額/年額両方に適用される可能性がある。実際の動作確認が必要
  - 候補：Stripe側の設定 / サーバーサイドのトライアル処理

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |
| トライアル仕様 | 無料トライアルの適用条件が不明確 | 0: 低リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] Stripe接続状態による表示切り替えが正しいか確認
- [ ] 価格バリデーションが通貨ごとに正しく機能するか確認
- [ ] 無料トライアルの適用条件を確認
- [ ] portal_plans設定の同期が正しく行われるか確認
