---
generated_at: 2026-01-29 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：46-ポータル設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/membership/portal.tsx` (1-83行目)
- E-02: `apps/admin-x-settings/src/components/settings/membership/portal/portal-modal.tsx` (1-241行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (46行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (77行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ポータル設定画面は会員ポータルのカスタマイズを行う | E-02 | ○ |
| C-02 | 画面へのアクセスはSettings→Membership→Signup portalカードから | E-01 (navid='portal') | ○ |
| C-03 | URLは/ghost/#/settings/portal/edit | E-01 (32行目 updateRoute) | ○ |
| C-04 | メンバーシップ無効時はCustomizeボタンが無効化される | E-01 (39行目 disabled) | ○ |
| C-05 | useFormフックで設定とティアを管理 | E-02 (115-155行目) | ○ |
| C-06 | プレビューはSignup/Account page/Linksの3タブ | E-02 (208-212行目) | ○ |
| C-07 | サイドバーはSignup options/Look & feel/Account pageの3タブ | E-02 (27-49行目) | ○ |
| C-08 | 設定変更は編集ティアはeditTierで保存 | E-02 (124行目) | ○ |
| C-09 | 設定変更はeditSettingsで保存 | E-02 (133行目) | ○ |
| C-10 | サポートメール変更時は検証が必要 | E-02 (136-150行目) | ○ |
| C-11 | 検証モーダルで確認メール送信を通知 | E-02 (141-150行目) | ○ |
| C-12 | useBrowseTiersでティア一覧を取得 | E-02 (71行目) | ○ |
| C-13 | verifyEmailTokenでメール検証 | E-02 (75-113行目) | ○ |
| C-14 | updateSettingで設定を更新 | E-02 (165-171行目) | ○ |
| C-15 | updateTierでティアを更新 | E-02 (181-187行目) | ○ |
| C-16 | PortalPreviewコンポーネントでプレビュー表示 | E-02 (202-206行目) | ○ |
| C-17 | PreviewModalContentでモーダルレイアウト | E-02 (214-237行目) | ○ |
| C-18 | dirtyフラグで変更検出 | E-02 (124, 131行目) | ○ |
| C-19 | アクセントカラーとアイコンを取得して表示 | E-01 (29行目) | ○ |
| C-20 | 関連機能はPortal（No.71） | E-04 | ○ |
| C-21 | サイトプレビュー画像をカード内に表示 | E-01 (46-77行目) | ○ |
| C-22 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、ポータル設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] メール検証フローが正しく動作するか確認
- [ ] プレビューがリアルタイムで反映されるか確認
- [ ] ティアと設定の同時保存が正しく行われるか確認
