---
generated_at: 2026-01-29 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：47-スパムフィルター設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/spam-filters.tsx` (1-83行目)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (47行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (78行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スパムフィルター設定画面はブロックドメインを設定する | E-01 | ○ |
| C-02 | 画面へのアクセスはSettings→Membership→Spam filtersカードから | E-01 (navid='spam-filters') | ○ |
| C-03 | blocked_email_domains設定でドメインを保存 | E-01 (24, 37行目) | ○ |
| C-04 | 入力はスペース/カンマ/改行で分割される | E-01 (33行目 split(/[\s,]+/)) | ○ |
| C-05 | ドメインは小文字化される | E-01 (34行目 toLowerCase()) | ○ |
| C-06 | @以降のドメイン部分のみが抽出される | E-01 (34行目 split('@').pop()) | ○ |
| C-07 | ドットを含まないドメインは除外される | E-01 (35行目 filter) | ○ |
| C-08 | JSON配列形式で保存される | E-01 (37行目 JSON.stringify) | ○ |
| C-09 | 初期値はJSONからパースして改行区切りに変換 | E-01 (24-26行目) | ○ |
| C-10 | TextAreaで入力を受け付ける | E-01 (65-75行目) | ○ |
| C-11 | hideEditButton=trueで編集ボタン非表示 | E-01 (59行目) | ○ |
| C-12 | ヒントテキストで使い方を説明 | E-01 (44-48行目) | ○ |
| C-13 | プレースホルダーに例を表示 | E-01 (69行目) | ○ |
| C-14 | 関連機能は一般設定（No.35） | E-03 | ○ |
| C-15 | useSettingGroupでローカル設定を管理 | E-01 (8-22行目) | ○ |
| C-16 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、スパムフィルター設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] ドメイン正規化ロジックが正しく動作するか確認
- [ ] 無効なドメインが適切に除外されるか確認
- [ ] JSON形式での保存と読み込みが正しく行われるか確認
