---
generated_at: 2026-01-29 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：48-ニュースレター有効化設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/email/enable-newsletters.tsx` (1-82行目)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (48行目)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (79行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター有効化設定画面はニュースレター機能の有効/無効を切り替える | E-01 | ○ |
| C-02 | 画面へのアクセスはSettings→Email→Newsletter sendingカードから | E-01 (navid='enable-newsletters') | ○ |
| C-03 | editor_default_email_recipients設定で管理 | E-01 (15, 21行目) | ○ |
| C-04 | 有効化時は'visibility'に設定 | E-01 (21行目) | ○ |
| C-05 | 無効化時は'disabled'に設定 | E-01 (21行目) | ○ |
| C-06 | 無効化時にeditor_default_email_recipients_filterをnullに | E-01 (24-26行目) | ○ |
| C-07 | useEditSettingsで即時保存 | E-01 (11, 29行目) | ○ |
| C-08 | トグルはcustomButtonsとして表示 | E-01 (46行目) | ○ |
| C-09 | members_signup_access='none'の判定 | E-01 (17行目) | ○ |
| C-10 | 警告バナーでサブスクリプション無効を通知 | E-01 (64-68行目) | ○ |
| C-11 | 警告内のリンクでmembers設定に遷移 | E-01 (65-67行目) | ○ |
| C-12 | Enabledアイコンはcheck | E-01 (59行目) | ○ |
| C-13 | Disabledアイコンはmail-block | E-01 (72行目) | ○ |
| C-14 | handleErrorでエラー処理 | E-01 (13, 31行目) | ○ |
| C-15 | 関連機能はニュースレター管理（No.20） | E-03 | ○ |
| C-16 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、ニュースレター有効化設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] トグル変更が即時保存されるか確認
- [ ] サブスクリプション無効時の警告が正しく表示されるか確認
- [ ] 警告内のリンクが正しく機能するか確認
