---
generated_at: 2026-01-29 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：49-デフォルト受信者設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/email/default-recipients.tsx` (1-169行目)
- E-02: `apps/admin-x-settings/src/components/settings/email/use-default-recipients-options.tsx` (1-99行目)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (49行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (80行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト受信者設定画面は配信対象を設定する | E-01 | ○ |
| C-02 | 画面へのアクセスはSettings→Email→Default recipientsカードから | E-01 (navid='default-recipients' 132行目) | ○ |
| C-03 | RECIPIENT_FILTER_OPTIONSで5つのプリセット定義 | E-01 (14-34行目) | ○ |
| C-04 | visibility選択時はeditor_default_email_recipients='visibility' | E-01 (87-89行目) | ○ |
| C-05 | all-members選択時はfilter='status:free,status:-free' | E-01 (94-96行目) | ○ |
| C-06 | paid-only選択時はfilter='status:-free' | E-01 (98-100行目) | ○ |
| C-07 | none選択時はfilter=null | E-01 (102-104行目) | ○ |
| C-08 | segment選択時はカスタムフィルター | E-01 (91-92行目, 112-125行目) | ○ |
| C-09 | getDefaultRecipientValueで設定値をUI値に変換 | E-01 (36-53行目) | ○ |
| C-10 | useDefaultRecipientsOptionsでセグメント選択 | E-02 (20-97行目) | ○ |
| C-11 | useFilterableApiでティア/ラベル/オファーを取得 | E-02 (21-23行目) | ○ |
| C-12 | SIMPLE_SEGMENT_OPTIONSでFree/Paid members | E-02 (10-18行目) | ○ |
| C-13 | loadOptionsでグループ化されたオプション提供 | E-02 (31-61行目) | ○ |
| C-14 | debounce(500ms)でloadOptionsを遅延 | E-02 (93行目) | ○ |
| C-15 | initSelectedSegmentsで初期値を復元 | E-02 (63-84行目) | ○ |
| C-16 | セグメント全解除時にnoneに切り替え | E-01 (118-121行目) | ○ |
| C-17 | useEffectでキャンセル時に選択状態をリセット | E-01 (78-84行目) | ○ |
| C-18 | hideEditButton=trueで編集ボタン非表示 | E-01 (136行目) | ○ |
| C-19 | 関連機能はニュースレター管理（No.20） | E-04 | ○ |
| C-20 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、デフォルト受信者設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] 5つのプリセットオプションが正しく動作するか確認
- [ ] セグメント選択が正しく保存されるか確認
- [ ] キャンセル時に選択状態が正しくリセットされるか確認
- [ ] ティア/ラベル/オファーが正しく読み込まれるか確認
