---
generated_at: 2026-01-29 21:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-サインアウト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/signout.js` - サインアウトルート
- E-02: `ghost/admin/app/routes/authenticated.js` - 認証済みルート基底クラス
- E-03: `ghost/admin/app/authenticators/cookie.js` - Cookie認証実装
- E-04: `ghost/core/core/server/api/endpoints/session.js` - セッションAPIエンドポイント
- E-05: `ghost/core/core/server/services/auth/session/middleware.js` - セッションミドルウェア
- E-06: `ghost/core/core/server/services/auth/session/session-service.js` - セッションサービス
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /ghost/signoutへのアクセスでサインアウト | E-01, E-07 | ○ |
| C-02 | 専用画面は存在しない | E-01（テンプレート未定義） | ○ |
| C-03 | AuthenticatedRouteを継承 | E-01 (1行目, 4行目) | ○ |
| C-04 | afterModelで処理実行 | E-01 (7-10行目) | ○ |
| C-05 | notifications.clearAll()で通知クリア | E-01 (8行目) | ○ |
| C-06 | session.invalidate()でセッション無効化 | E-01 (9行目) | ○ |
| C-07 | DELETE /sessionでサーバー側セッション削除 | E-03 (60行目: ajax.del) | ○ |
| C-08 | skipSessionDeletionでDELETEスキップ | E-03 (55-57行目) | ○ |
| C-09 | SessionMiddleware.logoutでセッション削除 | E-05 (29-40行目) | ○ |
| C-10 | removeUserForSessionでuser_id削除 | E-06 (320-328行目) | ○ |
| C-11 | 2FA必須時にverifiedもクリア | E-06 (323-325行目) | ○ |
| C-12 | 未認証時はサインイン画面へリダイレクト | E-02 (10-17行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：処理フロー - コードから明確に確認可能
- **0（低リスク）**：セッション削除 - サービス・ミドルウェアから確認可能
- **0（低リスク）**：例外処理 - authenticatorから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] サインアウト後のサインイン画面リダイレクトが正しく動作するか確認
- [ ] セッション削除APIエラー時の動作を確認
- [ ] skipSessionDeletionフラグの動作条件を確認
- [ ] 全通知クリアが適切か確認（重要な通知の消失リスク）
