---
generated_at: 2026-01-29 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：50-ニュースレター設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：Administrator以上のロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/email/newsletters.tsx` (1-169行目)
- E-02: `apps/admin-x-settings/src/components/settings/email/newsletters/newsletters-list.tsx` (1-107行目)
- E-03: `apps/admin-x-framework/src/api/newsletters.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (50行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (81行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター設定画面は一覧と管理を提供 | E-01 | ○ |
| C-02 | 画面へのアクセスはSettings→Email→Newslettersカードから | E-01 (navid='newsletters' 155行目) | ○ |
| C-03 | Active/Archivedの2タブで管理 | E-01 (137-148行目) | ○ |
| C-04 | useBrowseNewslettersで無限スクロール対応 | E-01 (30行目) | ○ |
| C-05 | Add newsletterボタンで新規作成 | E-01 (26-28行目, 92-96行目) | ○ |
| C-06 | updateRoute('newsletters/new')で新規作成モーダル | E-01 (27行目) | ○ |
| C-07 | updateRoute('newsletters/{id}')で編集モーダル | E-02 (25, 54行目) | ○ |
| C-08 | アクティブなニュースレターのみ並び替え可能 | E-01 (141行目 isSortable) | ○ |
| C-09 | arrayMoveで新しい順序を計算 | E-01 (104行目) | ○ |
| C-10 | ローカルステートとキャッシュを即時更新 | E-01 (117, 118-130行目) | ○ |
| C-11 | editNewsletterでsort_orderを保存 | E-01 (132-134行目) | ○ |
| C-12 | verifyEmailTokenでメール検証 | E-01 (34, 44-90行目) | ○ |
| C-13 | sender_email検証時のメッセージ | E-01 (55-57行目) | ○ |
| C-14 | sender_reply_to検証時のメッセージ | E-01 (58-60行目) | ○ |
| C-15 | Token expired時のエラーメッセージ | E-01 (76-77行目) | ○ |
| C-16 | isEnd=falseでLoad moreボタン表示 | E-01 (160-164行目) | ○ |
| C-17 | fetchNextPageで次ページ取得 | E-01 (163行目) | ○ |
| C-18 | ニュースレター名・説明・購読者数・配信数を表示 | E-02 (58-78行目) | ○ |
| C-19 | numberWithCommasでカンマ区切り表示 | E-02 (67, 73行目) | ○ |
| C-20 | 一覧が空の場合NoValueLabelで表示 | E-02 (101-103行目) | ○ |
| C-21 | SortableListでドラッグ&ドロップ | E-02 (85-91行目) | ○ |
| C-22 | DragIndicatorで並び替えハンドル表示 | E-02 (36-38行目) | ○ |
| C-23 | 関連機能はニュースレター管理（No.20） | E-05 | ○ |
| C-24 | Administrator以上のロールを持つユーザーのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **権限制御の実装箇所**: 管理画面全体のルーティングで権限チェックが行われている可能性があるが、ニュースレター設定画面固有の権限制御コードは確認できなかった
  - 候補：`ghost/admin/app/routes/` / `apps/admin-x-settings/src/routes.tsx` / サーバーサイドAPI

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| 権限制御 | 権限チェックの実装箇所が不明確 | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Administrator以上の権限制御が適切に実装されているか確認
- [ ] Active/Archivedタブの切り替えが正しく動作するか確認
- [ ] ドラッグ&ドロップによる並び替えが正しく保存されるか確認
- [ ] メール検証フローが正しく動作するか確認
- [ ] 無限スクロールが正しく動作するか確認
- [ ] 楽観的UIの更新とAPIの同期が正しく行われるか確認
