---
generated_at: 2026-01-29 20:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-Mailgun設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **権限制御の詳細**：ロール別アクセス制御の実装箇所が未確認
  2. **暗号化保存**：APIキーの暗号化処理はバックエンド側で要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/admin-x-settings/src/components/settings/email/mailgun.tsx`
- E-02: `apps/admin-x-settings/src/hooks/use-setting-group.tsx`
- E-03: `apps/admin-x-framework/src/api/settings.ts`
- E-04: `apps/admin-x-settings/src/components/top-level-group.tsx`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Mailgun設定は3つの設定値（region, domain, api_key）を管理する | E-01 (26-28行目) | ○ |
| C-02 | リージョンはUS/EUの2種類から選択可能 | E-01 (8-11行目 MAILGUN_REGIONS定義) | ○ |
| C-03 | 設定完了状態はドメインとAPIキーの有無で判定 | E-01 (30行目 isMailgunSetup) | ○ |
| C-04 | useSettingGroupフックで状態管理を行う | E-01 (14-22行目), E-02 | ○ |
| C-05 | リージョン未設定時は保存時にデフォルト値（US）が設定される | E-01 (107-119行目 onSave処理) | ○ |
| C-06 | 設定値はPUT /settings/ APIで保存される | E-03 (38-60行目 useEditSettings) | ○ |
| C-07 | updateSetting関数で個別設定を更新しdirty状態を設定 | E-02 (90-100行目) | ○ |
| C-08 | TopLevelGroupでnavid='mailgun'が設定されている | E-01 (101行目) | ○ |
| C-09 | testId='mailgun'でテスト識別が可能 | E-01 (103行目) | ○ |
| C-10 | APIキーはパスワード形式（type='password'）で表示 | E-01 (81行目) | ○ |
| C-11 | 外部リンク「Why is this required?」がある | E-01 (93行目) | ○ |
| C-12 | 外部リンク「Find your Mailgun API keys」がある | E-01 (57行目) | ○ |
| C-13 | 設定成功時に緑色アイコンとメッセージを表示 | E-01 (35-39行目 IconLabel) | ○ |
| C-14 | 未設定時は「Mailgun is not set up」を表示 | E-01 (42-47行目) | ○ |
| C-15 | handleCancelで編集をキャンセル可能 | E-02 (79-82行目) | ○ |
| C-16 | handleSaveで設定を保存可能 | E-02 (108-115行目) | ○ |
| C-17 | changedSettings関数でdirtyな設定のみ抽出 | E-02 (68-76行目) | ○ |
| C-18 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (128行目) | ○ |
| C-19 | 関連機能No.67「メール配信管理」が主機能 | E-05 | ○ |
| C-20 | keywordsプロパティで検索機能と連携 | E-01 (13行目), E-04 (13-21行目) | ○ |
| C-21 | URLパスは#/settings/mailgun | E-01 (navid='mailgun'), E-07 | ○ |
| C-22 | 画面カテゴリは「設定-メール」 | E-06 | ○ |
| C-23 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |
| C-24 | APIキーは暗号化して保存される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない。バックエンドまたはEmber.js側のルーティングで制御されている可能性あり
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/api/ / ghost/core/core/server/services/permissions/

- **暗号化処理**：APIキーの暗号化はサーバーサイドの処理と推測されるが、フロントエンドコードからは確認不可
  - 候補：ghost/core/core/server/data/schema/ / ghost/core/core/server/models/settings.js

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - イベント仕様の記載
- 1: 中リスク - 権限制御の記載（要確認）
- 1: 中リスク - データベース暗号化の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] APIキーの暗号化処理がサーバー側で実装されているか確認
- [ ] リージョンのデフォルト値設定ロジックが正しいか確認
- [ ] 外部リンク（Mailgun docs）が有効か確認
