---
generated_at: 2026-01-29 20:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-ネットワーク設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/network.tsx`
- E-02: `apps/admin-x-framework/src/api/settings.ts`
- E-03: `apps/admin-x-settings/src/hooks/use-limiter.ts`（参照）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | social_web設定値でActivityPub機能をON/OFF制御する | E-01 (40行目) | ○ |
| C-02 | トグル変更時にeditSettingsを直接呼び出す | E-01 (44-54行目) | ○ |
| C-03 | 5つの無効化条件がOR判定される | E-01 (23-35行目) | ○ |
| C-04 | Ghost Pro制限はuseLimiterで取得 | E-01 (23-24行目), E-03 | ○ |
| C-05 | サブディレクトリ判定はgetGhostPathsとsubdirで行う | E-01 (26, 29行目) | ○ |
| C-06 | localhost判定は特定ホスト名のリスト比較 | E-01 (30行目) | ○ |
| C-07 | IP判定はvalidator.isIPを使用 | E-01 (31行目) | ○ |
| C-08 | プライベートモード判定はis_private設定から取得 | E-01 (28行目) | ○ |
| C-09 | 本番環境判定はNODE_ENV === 'production' | E-01 (27行目) | ○ |
| C-10 | 無効化時はトグルがdisabled状態になる | E-01 (63行目) | ○ |
| C-11 | 無効化時かつプライベートモード時は専用メッセージを表示 | E-01 (83-84行目) | ○ |
| C-12 | 無効化時かつホスティング問題時は専用メッセージとリンクを表示 | E-01 (85行目) | ○ |
| C-13 | プライベートモードリンクはupdateRoute('locksite')を呼ぶ | E-01 (84行目) | ○ |
| C-14 | 外部ヘルプリンクURLは正しい | E-01 (85行目) | ○ |
| C-15 | navid='network'が設定されている | E-01 (68行目) | ○ |
| C-16 | testId='network'でテスト識別が可能 | E-01 (69行目) | ○ |
| C-17 | 説明画像network.pngを表示 | E-01 (2行目 import, 93行目) | ○ |
| C-18 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (99行目) | ○ |
| C-19 | 関連機能No.57「ActivityPub」が主機能 | E-04 | ○ |
| C-20 | 対応プラットフォームの説明文が記載されている | E-01 (66行目) | ○ |
| C-21 | isCheckedはsocialWebSetting && !isDisabledで決定 | E-01 (41行目) | ○ |
| C-22 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない。バックエンドまたはEmber.js側のルーティングで制御されている可能性あり
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - 無効化条件の記載（コードから明確）
- 0: 低リスク - イベント仕様の記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] 5つの無効化条件が正しく動作するか確認
- [ ] 外部リンク（Ghost help）が有効か確認
- [ ] network.png画像が正しく表示されるか確認
