---
generated_at: 2026-01-29 20:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：53-Explore設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/explore.tsx`
- E-02: `apps/admin-x-framework/src/api/settings.ts`
- E-03: `apps/admin-x-framework/src/api/members.ts`
- E-04: `apps/admin-x-settings/src/hooks/use-setting-group.tsx`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | explore_ping設定でExplore掲載をON/OFF制御する | E-01 (38行目, 65行目) | ○ |
| C-02 | explore_ping_growth設定で成長データ共有をON/OFF制御する | E-01 (39行目, 86行目) | ○ |
| C-03 | トグル変更時にeditSettingsを直接呼び出す | E-01 (47-57行目) | ○ |
| C-04 | useBrowseMembersでメンバー数を取得する | E-01 (21-33行目), E-03 | ○ |
| C-05 | メンバー数はpagination.totalから取得 | E-01 (28-29行目) | ○ |
| C-06 | exploreEnabled時にプレビューカードを表示 | E-01 (74行目) | ○ |
| C-07 | アイコン未設定時はアクセントカラー背景のデフォルトロゴを表示 | E-01 (96-100行目) | ○ |
| C-08 | shareGrowthData時にメンバー数バッジを表示 | E-01 (108-111行目) | ○ |
| C-09 | abbreviateNumberでメンバー数を省略形式に変換 | E-01 (8行目 import, 110行目) | ○ |
| C-10 | Send testimonialボタンでupdateRoute('explore/testimonial')を呼ぶ | E-01 (125-127行目) | ○ |
| C-11 | navid='explore'が設定されている | E-01 (70行目) | ○ |
| C-12 | testId='explore'でテスト識別が可能 | E-01 (71行目) | ○ |
| C-13 | 説明画像ghost-explore.pngを表示 | E-01 (3行目 import, 131行目) | ○ |
| C-14 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (136行目) | ○ |
| C-15 | 関連機能No.91「Explore連携」が主機能 | E-05 | ○ |
| C-16 | 成長データ共有トグルにヒント文が表示される | E-01 (82行目) | ○ |
| C-17 | プレビューカードにPreviewラベルが表示される | E-01 (90行目) | ○ |
| C-18 | サイトURLはsiteData.urlから取得 | E-01 (41-42行目) | ○ |
| C-19 | siteDomainはURLからプロトコルを除去して生成 | E-01 (42行目) | ○ |
| C-20 | accent_color未設定時はデフォルト値#F6414Eを使用 | E-01 (44行目) | ○ |
| C-21 | FakeLogoはexplore-default-logo.pngをimport | E-01 (1行目) | ○ |
| C-22 | testId='explore-toggle'でメイントグルを識別可能 | E-01 (64行目) | ○ |
| C-23 | testId='explore-growth-toggle'で成長データトグルを識別可能 | E-01 (85行目) | ○ |
| C-24 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - プレビュー表示の条件分岐
- 0: 低リスク - イベント仕様の記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] メンバー数取得が正しく動作するか確認
- [ ] プレビューカードの表示が意図通りか確認
- [ ] Testimonialモーダル遷移が正しく動作するか確認
