---
generated_at: 2026-01-29 20:38:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：54-レコメンデーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/recommendations.tsx`
- E-02: `apps/admin-x-settings/src/components/settings/growth/recommendations/recommendation-list.tsx`
- E-03: `apps/admin-x-settings/src/components/settings/growth/recommendations/incoming-recommendation-list.tsx`
- E-04: `apps/admin-x-framework/src/api/recommendations.ts`
- E-05: `apps/admin-x-framework/src/api/referrers.ts`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useBrowseRecommendationsで推薦リストを取得する | E-01 (18行目), E-04 (33-50行目) | ○ |
| C-02 | useBrowseIncomingRecommendationsで受信推薦リストを取得する | E-01 (52行目), E-04 (102-119行目) | ○ |
| C-03 | useReferrerHistoryで流入統計を取得する | E-01 (79行目), E-05 | ○ |
| C-04 | 初回5件、以降100件ずつページネーション | E-01 (22-43行目, 54-75行目) | ○ |
| C-05 | TabViewで2つのタブを切り替える | E-01 (89-102行目, 137行目) | ○ |
| C-06 | selectedTabの初期値は'your-recommendations' | E-01 (87行目) | ○ |
| C-07 | Add recommendationボタンでupdateRoute('recommendations/add')を呼ぶ | E-01 (110-112行目) | ○ |
| C-08 | beta=trueでベータ機能としてマーク | E-01 (122行目) | ○ |
| C-09 | navid='recommendations'が設定されている | E-01 (127行目) | ○ |
| C-10 | testId='recommendations'でテスト識別が可能 | E-01 (128行目) | ○ |
| C-11 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (142行目) | ○ |
| C-12 | 関連機能No.60「サイトレコメンデーション」が主機能 | E-06 | ○ |
| C-13 | RecommendationItemクリックでEditRecommendationModalを表示 | E-02 (23-29行目) | ○ |
| C-14 | one_click_subscribeでGhostサイト判定 | E-02 (31行目) | ○ |
| C-15 | Ghostサイトはsubscribers、非Ghostサイトはclicksを表示 | E-02 (32-33行目) | ○ |
| C-16 | 共有リンクは/#/portal/recommendations形式 | E-02 (72行目) | ○ |
| C-17 | リンクコピーは2秒後に表示リセット | E-02 (83-84行目) | ○ |
| C-18 | 推薦なし時は「Add first recommendation」ボタンを表示 | E-02 (97-101行目) | ○ |
| C-19 | IncomingRecommendationItemでsignupsをドメインマッチングで計算 | E-03 (20-35行目) | ○ |
| C-20 | recommendBack関数でurl付きで追加モーダルを開く | E-03 (37-39行目) | ○ |
| C-21 | recommending_back=trueの場合はRecommend backボタンを非表示 | E-03 (49-54行目) | ○ |
| C-22 | 受信推薦なし時は案内メッセージを表示 | E-03 (93-95行目) | ○ |
| C-23 | Recommendation型にcount.subscribers/count.clicksがある | E-04 (15行目) | ○ |
| C-24 | IncomingRecommendation型にrecommending_backがある | E-04 (94行目) | ○ |
| C-25 | numberWithCommasで数値をカンマ区切り表示 | E-02 (54行目), E-03 (71行目) | ○ |
| C-26 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - タブ切り替えの記載
- 0: 低リスク - ページネーションの記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] ページネーションが正しく動作するか確認
- [ ] ドメインマッチングによるsignups計算が正確か確認
- [ ] 推薦返し機能が正しく動作するか確認
