---
generated_at: 2026-01-29 20:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：55-埋め込みフォーム設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/embed-signup/embed-signup-form.tsx`
- E-02: `apps/admin-x-settings/src/components/top-level-group.tsx`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useRoutingフックでルーティング関数を取得する | E-01 (4行目 import, 7行目) | ○ |
| C-02 | openPreviewModal関数でupdateRoute('embed-signup-form/show')を呼ぶ | E-01 (8-10行目) | ○ |
| C-03 | EmbedボタンのクリックでopenPreviewModalが呼ばれる | E-01 (14行目) | ○ |
| C-04 | ボタンのlabelは'Embed' | E-01 (14行目) | ○ |
| C-05 | ボタンのcolor='clear'、size='sm' | E-01 (14行目) | ○ |
| C-06 | title='Signup forms' | E-01 (19行目) | ○ |
| C-07 | description='Grow your audience from anywhere on the web' | E-01 (16行目) | ○ |
| C-08 | navid='embed-signup-form' | E-01 (17行目) | ○ |
| C-09 | testId='embed-signup-form' | E-01 (18行目) | ○ |
| C-10 | 関連機能No.73「Signup Form」が主機能 | E-03 | ○ |
| C-11 | TopLevelGroupでラップされている | E-01 (12-21行目), E-02 | ○ |
| C-12 | シンプルなコンポーネント構造（状態管理なし） | E-01（全体、useState/useEffectなし） | ○ |
| C-13 | keywordsプロパティがpropsで受け取られる | E-01 (6行目, 15行目) | ○ |
| C-14 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

- **モーダルの実装詳細**：embed-signup-form/showのモーダル実装は別ファイルにある可能性
  - 候補：apps/admin-x-settings/src/components/settings/growth/embed-signup/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示の記載
- 0: 低リスク - ルーティングの記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] モーダル（embed-signup-form/show）が正しく開くか確認
- [ ] 埋め込みフォームのプレビュー・コード生成が正しく動作するか確認
