---
generated_at: 2026-01-29 20:43:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：56-オファー設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/offers.tsx`
- E-02: `apps/admin-x-settings/src/components/settings/growth/offers/offers-index.tsx`
- E-03: `apps/admin-x-framework/src/api/offers.ts`
- E-04: `apps/admin-x-framework/src/api/tiers.ts`
- E-05: `apps/admin-x-framework/src/api/settings.ts`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useBrowseOffersでオファー一覧を取得する | E-01 (35行目), E-03 (47-52行目) | ○ |
| C-02 | useBrowseTiersでTier一覧を取得する | E-01 (37行目), E-04 | ○ |
| C-03 | getPaidActiveTiersでアクティブな有料Tierを抽出 | E-01 (38行目), E-04 | ○ |
| C-04 | redemption_type='signup'でフィルタリング | E-01 (40行目) | ○ |
| C-05 | status='active'でフィルタリング | E-01 (42-44行目) | ○ |
| C-06 | created_at descでソート | E-01 (46-50行目) | ○ |
| C-07 | 最新3件を表示 | E-01 (52行目 slice(0, 3)) | ○ |
| C-08 | オファーが4件以上で「X offers in total」を表示 | E-01 (112-114行目) | ○ |
| C-09 | goToOfferEditでsessionStorageに値を設定 | E-01 (67行目) | ○ |
| C-10 | checkStripeEnabledでStripe有効化チェック | E-01 (88行目), E-05 (105-116行目) | ○ |
| C-11 | navid='offers'が設定されている | E-01 (91行目) | ○ |
| C-12 | testId='offers'でテスト識別が可能 | E-01 (92行目) | ○ |
| C-13 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (130行目) | ○ |
| C-14 | 関連機能No.16「オファー管理」が主機能 | E-06 | ○ |
| C-15 | OfferContainerでカード表示 | E-01 (12-29行目) | ○ |
| C-16 | getOfferDiscountで割引表示を計算 | E-01 (14行目), E-02 (34-76行目) | ○ |
| C-17 | CopyLinkButtonでリンクコピー機能 | E-01 (25行目), E-02 (78-91行目) | ○ |
| C-18 | コピー後2秒でリセット | E-02 (86-87行目) | ○ |
| C-19 | リデンプション数クリックでメンバー一覧へ遷移 | E-01 (24行目 href), E-02 (20-24行目 createRedemptionFilterUrl) | ○ |
| C-20 | updateRoute('/tiers')でTier設定へ遷移 | E-01 (62-64行目) | ○ |
| C-21 | paidActiveTiers.length === 0で警告表示 | E-01 (118-124行目) | ○ |
| C-22 | Offer型にtype/amount/duration/cadenceがある | E-03 (4-26行目) | ○ |
| C-23 | オファータイプはpercent/fixed/trial | E-03 (10行目), E-02 (44-60行目) | ○ |
| C-24 | durationはonce/repeating/forever | E-02 (30-32行目) | ○ |
| C-25 | OffersIndexModalでActive/Archivedタブ | E-02 (117-120行目) | ○ |
| C-26 | ソート機能あり（date-added/name/redemptions） | E-02 (247-251行目) | ○ |
| C-27 | Tierアーカイブ時はオファーも無効化 | E-02 (113-115行目, 174行目 isTierArchived) | ○ |
| C-28 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - フィルタリング・ソートの記載
- 0: 低リスク - Stripeチェックの記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] Stripe未設定時のボタン無効化が正しく動作するか確認
- [ ] リデンプションフィルターURLが正しいか確認
- [ ] Tierアーカイブ時のオファー無効化表示が正しいか確認
