---
generated_at: 2026-01-29 20:46:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：57-投げ銭・寄付設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/growth/tips-and-donations.tsx`
- E-02: `apps/admin-x-settings/src/hooks/use-setting-group.tsx`
- E-03: `apps/admin-x-settings/src/utils/currency.ts`（参照）
- E-04: `apps/admin-x-framework/src/api/settings.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | donations_suggested_amountで推奨金額を管理 | E-01 (33行目) | ○ |
| C-02 | donations_currencyで通貨を管理 | E-01 (32行目) | ○ |
| C-03 | デフォルト値はUSDと500（5ドル） | E-01 (32-33行目) | ○ |
| C-04 | MAX_AMOUNT = 10,000（Stripe制限） | E-01 (9行目) | ○ |
| C-05 | useSettingGroupでonValidateオプションを使用 | E-01 (24-30行目), E-02 | ○ |
| C-06 | validateCurrencyAmountでバリデーション | E-01 (27行目), E-03 | ○ |
| C-07 | 寄付URLはsiteUrl/#/portal/support形式 | E-01 (38行目) | ○ |
| C-08 | copyDonateUrlでクリップボードにコピー | E-01 (56-59行目) | ○ |
| C-09 | コピー後2秒でリセット | E-01 (58行目) | ○ |
| C-10 | openPreviewでconfirmIfDirtyを使用 | E-01 (62-64行目) | ○ |
| C-11 | localSettings変更でisEditingを更新 | E-01 (48-54行目) | ○ |
| C-12 | hideEditButton=trueが設定されている | E-01 (91行目) | ○ |
| C-13 | navid='tips-and-donations' | E-01 (87行目) | ○ |
| C-14 | testId='tips-and-donations' | E-01 (89行目) | ○ |
| C-15 | withErrorBoundaryでエラーバウンダリが設定 | E-01 (145行目) | ○ |
| C-16 | 関連機能No.17「寄付機能」が主機能 | E-05 | ○ |
| C-17 | CurrencyFieldコンポーネントで金額入力 | E-01 (98-123行目) | ○ |
| C-18 | Selectコンポーネントで通貨選択 | E-01 (105-116行目) | ○ |
| C-19 | currencySelectGroupsから通貨リストを取得 | E-01 (110行目), E-03 | ○ |
| C-20 | onBlurでvalidateを実行 | E-01 (120行目) | ○ |
| C-21 | onKeyDownでclearErrorを実行 | E-01 (122行目) | ○ |
| C-22 | handleSettingChangeで設定を更新 | E-01 (66-68行目) | ○ |
| C-23 | handleCancelClickで変更を破棄 | E-01 (70-73行目) | ○ |
| C-24 | handleSaveClickで保存 | E-01 (75-80行目) | ○ |
| C-25 | Stripeポリシーリンクが表示される | E-01 (138-140行目) | ○ |
| C-26 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - バリデーションの記載
- 0: 低リスク - 共有リンク機能の記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] バリデーション（0 < amount <= 10000）が正しく動作するか確認
- [ ] 通貨選択リストが正しく表示されるか確認
- [ ] 寄付ページ（Portal）が正しく表示されるか確認
