---
generated_at: 2026-01-29 20:49:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：58-インテグレーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/integrations.tsx`
- E-02: `apps/admin-x-framework/src/api/integrations.ts`
- E-03: `apps/admin-x-framework/src/api/settings.ts`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | useBrowseIntegrationsでインテグレーション一覧を取得 | E-01 (222行目), E-02 (31-35行目) | ○ |
| C-02 | selectedTabの初期値は'built-in' | E-01 (221行目) | ○ |
| C-03 | TabViewで2つのタブを切り替える | E-01 (225-236行目, 274行目) | ○ |
| C-04 | BuiltInIntegrationsでビルトインを表示 | E-01 (75-163行目) | ○ |
| C-05 | CustomIntegrationsでカスタムを表示 | E-01 (165-218行目) | ○ |
| C-06 | filter(type === 'custom')でカスタムのみ抽出 | E-01 (234行目) | ○ |
| C-07 | zapierDisabledでGhost Pro制限チェック | E-01 (83行目) | ○ |
| C-08 | usePinturaEditorでPintura有効状態取得 | E-01 (86行目) | ○ |
| C-09 | useFeatureFlag('transistor')でフラグ取得 | E-01 (84行目) | ○ |
| C-10 | 各設定値でActive状態を判定 | E-01 (89-95行目) | ○ |
| C-11 | IntegrationItemでアイテム表示 | E-01 (26-73行目) | ○ |
| C-12 | active時に緑色Activeバッジを表示 | E-01 (70行目) | ○ |
| C-13 | disabled時にグレーアウトとUpgradeボタン表示 | E-01 (58-60行目, 66行目) | ○ |
| C-14 | カスタムインテグレーションにDeleteボタン | E-01 (55-56行目) | ○ |
| C-15 | 削除時にConfirmationModalを表示 | E-01 (187行目) | ○ |
| C-16 | 削除確認メッセージが正しい | E-01 (188-189行目) | ○ |
| C-17 | deleteIntegrationでAPIを呼び出す | E-01 (194行目), E-02 (70-80行目) | ○ |
| C-18 | 削除成功時にshowToastを表示 | E-01 (196-200行目) | ○ |
| C-19 | カスタムがない場合NoValueLabelを表示 | E-01 (214-216行目) | ○ |
| C-20 | Add custom integrationボタンでupdateRoute('integrations/new') | E-01 (244行目) | ○ |
| C-21 | ボタン押下時にselectedTabを'custom'に変更 | E-01 (245行目) | ○ |
| C-22 | navid='integrations' | E-01 (271行目) | ○ |
| C-23 | testId='integrations' | E-01 (272行目) | ○ |
| C-24 | withErrorBoundaryでエラーバウンダリ設定 | E-01 (279行目) | ○ |
| C-25 | 関連機能No.46「カスタムインテグレーション」が主機能 | E-04 | ○ |
| C-26 | Integration型にtype/api_keys/webhooksがある | E-02 (7-18行目) | ○ |
| C-27 | ヘッダー画像integrations-settings.pngを表示 | E-01 (1行目 import, 257行目) | ○ |
| C-28 | handleErrorでエラー処理 | E-01 (168行目, 203-205行目) | ○ |
| C-29 | Transistorはフィーチャーフラグ有効時のみ表示 | E-01 (149-159行目) | ○ |
| C-30 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - タブ切り替えの記載
- 0: 低リスク - 削除処理の記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] Ghost Pro制限が正しく適用されるか確認
- [ ] カスタムインテグレーション削除時に関連APIキー/Webhookも削除されるか確認
- [ ] 各ビルトインインテグレーションのActive判定が正しいか確認
