---
generated_at: 2026-01-29 20:52:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：59-マイグレーションツール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/migration-tools.tsx`
- E-02: `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-import.tsx`
- E-03: `apps/admin-x-settings/src/components/settings/advanced/migration-tools/migration-tools-export.tsx`
- E-04: `apps/admin-x-framework/src/api/db.ts`
- E-05: `apps/admin-x-framework/src/api/posts.ts`（参照）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | selectedTabの初期値は'import' | E-01 (10行目) | ○ |
| C-02 | TabViewで2つのタブを切り替える | E-01 (12-23行目, 34行目) | ○ |
| C-03 | MigrationToolsImportをインポートタブに表示 | E-01 (16行目) | ○ |
| C-04 | MigrationToolsExportをエクスポートタブに表示 | E-01 (21行目) | ○ |
| C-05 | navid='migration' | E-01 (31行目) | ○ |
| C-06 | testId='migrationtools' | E-01 (32行目) | ○ |
| C-07 | withErrorBoundaryでエラーバウンダリ設定 | E-01 (39行目) | ○ |
| C-08 | Substackボタンで/migrate/substackへ遷移 | E-02 (46行目) | ○ |
| C-09 | WordPressボタンで/migrate/wordpressへ遷移 | E-02 (52行目) | ○ |
| C-10 | Squarespaceボタンで/migrate/squarespaceへ遷移 | E-02 (58行目) | ○ |
| C-11 | Mediumボタンで/migrate/mediumへ遷移 | E-02 (65行目) | ○ |
| C-12 | Mailchimpボタンで/migrate/mailchimpへ遷移 | E-02 (71行目) | ○ |
| C-13 | Universal importでUniversalImportModalを開く | E-02 (35-37行目) | ○ |
| C-14 | 関連機能No.65「データベース管理」が主機能 | E-06 | ○ |
| C-15 | usePostsExportsでlimit: '1000'を指定 | E-03 (9-12行目) | ○ |
| C-16 | exportPostsでCSVをBlobとしてダウンロード | E-03 (16-34行目) | ○ |
| C-17 | ファイル名はpost-analytics.{日付}.csv形式 | E-03 (25行目) | ○ |
| C-18 | downloadAllContentでContent & settingsをエクスポート | E-03 (38行目), E-04 (19行目) | ○ |
| C-19 | useImportContentでインポートAPIを定義 | E-04 (4-12行目) | ○ |
| C-20 | インポートはFormData形式でファイルを送信 | E-04 (7-10行目) | ○ |
| C-21 | downloadFromEndpointで/db/からダウンロード | E-04 (19行目) | ○ |
| C-22 | handleErrorでエクスポートエラー処理 | E-03 (31-33行目) | ○ |
| C-23 | 説明文が正しく表示される | E-01 (28行目) | ○ |
| C-24 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - タブ切り替えの記載
- 0: 低リスク - エクスポート処理の記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] 各プラットフォーム別マイグレーションページが正しく動作するか確認
- [ ] Universal importが正しくファイルをインポートできるか確認
- [ ] エクスポートファイルに機密情報が含まれていないか確認
