---
generated_at: 2026-01-29 21:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-セットアップ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/templates/setup.hbs` - セットアップフォームテンプレート
- E-02: `ghost/admin/app/routes/setup.js` - セットアップルート定義
- E-03: `ghost/admin/app/controllers/setup.js` - セットアップコントローラー
- E-04: `ghost/admin/app/validators/setup.js` - セットアップバリデータ
- E-05: `ghost/admin/app/validators/new-user.js` - 新規ユーザーバリデータ
- E-06: `ghost/core/core/server/api/endpoints/authentication.js` - 認証APIエンドポイント
- E-07: `ghost/core/core/server/services/auth/setup.js` - セットアップサービス
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ghost初回インストール後の初期設定画面 | E-02 (14-44行目: beforeModel) | ○ |
| C-02 | URL: /ghost/setup | E-02, E-08 | ○ |
| C-03 | サイトタイトル必須、1〜150文字 | E-04 (7-18行目) | ○ |
| C-04 | フルネーム必須、1文字以上 | E-05 (12-19行目) | ○ |
| C-05 | メールアドレス必須、形式チェック | E-05 (22-34行目) | ○ |
| C-06 | パスワード10文字以上、複雑性チェック | E-05 (36-38行目), password.js | ○ |
| C-07 | セットアップ完了済みならサインイン画面へ | E-02 (28-29行目) | ○ |
| C-08 | ログイン済みならホーム画面へ | E-02 (17-19行目) | ○ |
| C-09 | POST /authentication/setupでセットアップ実行 | E-03 (99-109行目), E-06 (25-81行目) | ○ |
| C-10 | オーナーユーザーを更新 | E-07 (63-80行目: setupUser) | ○ |
| C-11 | サイトタイトルと説明を設定 | E-07 (82-108行目: doSettings) | ○ |
| C-12 | デフォルト説明文 "Thoughts, stories and ideas." | E-07 (14行目, 96行目) | ○ |
| C-13 | デフォルトティアの名前更新 | E-07 (127-131行目) | ○ |
| C-14 | デフォルトニュースレターの名前更新 | E-07 (133-137行目) | ○ |
| C-15 | フィクスチャ投稿（coming-soon, about）更新 | E-07 (145-162行目: doFixtures) | ○ |
| C-16 | テーマインストール機能 | E-07 (196-227行目: installTheme) | ○ |
| C-17 | ウェルカムメール送信（設定による） | E-07 (164-194行目: sendWelcomeEmail) | ○ |
| C-18 | セットアップ後に自動ログイン | E-03 (121行目) | ○ |
| C-19 | セットアップ完了画面へ遷移 | E-03 (162行目: setup.done) | ○ |
| C-20 | blogCreatedフラグでPOST/PUT切り替え | E-03 (92行目) | ○ |
| C-21 | deactivateでパスワードクリア | E-02 (47-50行目) | ○ |
| C-22 | preValidateで値がある場合のみバリデーション | E-03 (40-46行目) | ○ |
| C-23 | 既存データの事前設定（title, name, email） | E-02 (31-42行目) | ○ |
| C-24 | オーナーユーザーはフィクスチャとして事前存在 | E-07 (66-72行目: findOne role: 'Owner') | ○ |
| C-25 | skipAuthSuccessHandlerで自動リダイレクト防止 | E-03 (55行目, 119行目) | ○ |
| C-26 | assertSetupCompleted(false)でセットアップ未完了を検証 | E-06 (37行目), E-07 (40-61行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし。全ての主張に対して十分な根拠が確認できた。

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**：入出力項目・バリデーション - コードから明確に確認可能
- **0（低リスク）**：画面遷移 - ルート・コントローラーから確認可能
- **0（低リスク）**：エラーメッセージ - バリデータ・サービスから確認可能
- **0（低リスク）**：DB更新仕様 - setup.jsから確認可能
- **0（低リスク）**：ウェルカムメール - setup.jsから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] セットアップ完了済み判定が正しく動作するか確認
- [ ] オーナーユーザーのフィクスチャデータが存在することを確認
- [ ] デフォルトティア・ニュースレターの更新が正しく動作するか確認
- [ ] テーマインストール失敗時のフォールバック動作を確認
- [ ] ウェルカムメール送信設定（sendWelcomeEmail）の確認
- [ ] パスワードクリア（deactivate）が確実に動作するか確認
