---
generated_at: 2026-01-29 20:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：60-コードインジェクション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：Administrator/Ownerロール制限の実装箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/code-injection.tsx`
- E-02: `apps/admin-x-settings/src/components/settings/advanced/code/code-modal.tsx`
- E-03: `apps/admin-x-settings/src/hooks/use-setting-group.tsx`
- E-04: `apps/admin-x-framework/src/api/settings.ts`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenボタンでNiceModal.show(CodeModal)を呼ぶ | E-01 (13-15行目) | ○ |
| C-02 | navid='code-injection' | E-01 (19行目) | ○ |
| C-03 | testId='code-injection' | E-01 (20行目) | ○ |
| C-04 | withErrorBoundaryでエラーバウンダリ設定 | E-01 (27行目) | ○ |
| C-05 | 関連機能No.32「コードインジェクション」が主機能 | E-05 | ○ |
| C-06 | useSettingGroupでフォーム状態管理 | E-02 (17-21行目), E-03 | ○ |
| C-07 | getSettingValuesでcodeinjection_head/footを取得 | E-02 (24行目) | ○ |
| C-08 | selectedTabの初期値は'header' | E-02 (26行目) | ○ |
| C-09 | TabViewで2つのタブを切り替える | E-02 (47-62行目, 108-113行目) | ○ |
| C-10 | CodeEditorでコードを編集 | E-02 (51, 58行目) | ○ |
| C-11 | html()をextensionsとして使用 | E-02 (31行目, 34行目) | ○ |
| C-12 | onChangeでupdateSettingを呼ぶ | E-02 (37行目, 44行目) | ○ |
| C-13 | ヘッダーのヒント文が正しい | E-02 (35行目) | ○ |
| C-14 | フッターのヒント文が正しい | E-02 (42行目) | ○ |
| C-15 | useSaveButtonで保存ボタン状態管理 | E-02 (64行目) | ○ |
| C-16 | Cmd+S/Ctrl+Sでショートカット保存 | E-02 (66-77行目) | ○ |
| C-17 | modal.remove()でモーダルを閉じる | E-02 (96行目) | ○ |
| C-18 | afterCloseコールバックが実行される | E-02 (97行目) | ○ |
| C-19 | ButtonGroupにClose/Saveボタンを配置 | E-02 (91-106行目) | ○ |
| C-20 | savingTitleがボタンラベルとして表示 | E-02 (102行目) | ○ |
| C-21 | isSavingでボタンのdisabled状態を制御 | E-02 (101行目) | ○ |
| C-22 | 'Saved'時にボタンカラーがgreenになる | E-02 (103行目) | ○ |
| C-23 | モーダルはsize='full'、height='full' | E-02 (84-86行目) | ○ |
| C-24 | testId='modal-code-injection' | E-02 (86行目) | ○ |
| C-25 | autoFocusがヘッダーエディタに設定 | E-02 (51行目) | ○ |
| C-26 | Administrator/Ownerロールのみアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **権限制御の実装**：フロントエンド側のコードではロール別制限の実装が確認できない
  - 候補：ghost/admin/app/routes/settings.js / ghost/core/core/server/services/permissions/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示・入力項目の記載
- 0: 低リスク - タブ切り替えの記載
- 0: 低リスク - キーボードショートカットの記載
- 1: 中リスク - 権限制御の記載（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御がバックエンド/Ember側で正しく実装されているか確認
- [ ] コードエディタのシンタックスハイライトが正しく動作するか確認
- [ ] Cmd+S / Ctrl+S ショートカットが正しく動作するか確認
- [ ] 挿入されたコードがテーマで正しくレンダリングされるか確認
