---
generated_at: 2026-01-29 21:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-Labs設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **settingsテーブル構造**：データベーススキーマの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/labs.tsx` - Labs画面メインコンポーネント
- E-02: `apps/admin-x-settings/src/components/settings/advanced/labs/beta-features.tsx` - Beta機能一覧
- E-03: `apps/admin-x-settings/src/components/settings/advanced/labs/private-features.tsx` - Private機能一覧
- E-04: `apps/admin-x-settings/src/components/settings/advanced/labs/feature-toggle.tsx` - 機能トグル
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Labs設定画面は実験的機能のオン/オフを切り替える画面である | E-01 (35-36行目: description) | ○ |
| C-02 | Beta featuresとPrivate featuresの2つのタブがある | E-01 (17-28行目: tabs配列) | ○ |
| C-03 | Private featuresタブはenableDeveloperExperiments有効時のみ表示 | E-01 (23行目: config.enableDeveloperExperiments条件) | ○ |
| C-04 | superEditors, editorExcerpt, additionalPaymentMethodsがBeta機能 | E-02 (18-29行目: FeatureToggle定義) | ○ |
| C-05 | リダイレクトファイルのアップロード・ダウンロード機能がある | E-02 (30-54行目: FileUpload, downloadRedirects) | ○ |
| C-06 | ルートファイルのアップロード・ダウンロード機能がある | E-02 (55-79行目: FileUpload, downloadRoutes) | ○ |
| C-07 | Private機能に15種類のフラグがある | E-03 (14-74行目: features配列) | ○ |
| C-08 | 機能トグルはlabs設定をJSON形式で更新する | E-04 (12-22行目: JSON.parse, JSON.stringify) | ○ |
| C-09 | 機能トグル変更時にアナリティクスイベントを送信する | E-04 (24行目: trackEvent) | ○ |
| C-10 | 成功時に「Redirects uploaded」トーストを表示 | E-02 (38-41行目: showToast) | ○ |
| C-11 | 成功時に「Routes uploaded」トーストを表示 | E-02 (63-66行目: showToast) | ○ |
| C-12 | 関連機能No.35は一般設定である | E-05 (Labs設定行) | ○ |
| C-13 | ナビゲーションIDは'labs'である | E-01 (49行目: navid='labs') | ○ |
| C-14 | limiterによる機能制限がある | E-03 (77-101行目: useLimiter, errorIfWouldGoOverLimit) | ○ |
| C-15 | editSettings APIを呼び出して設定を更新 | E-04 (20-23行目: editSettings呼び出し) | ○ |
| C-16 | クエリキャッシュのconfigデータを更新する | E-04 (25-33行目: client.setQueriesData) | ○ |
| C-17 | Labs画面はAdvancedセクションに配置されている | E-06 (61行目: 設定-高度カテゴリ) | ○ |
| C-18 | settingsテーブルのlabsキーにJSON形式で保存される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **settingsテーブルのスキーマ定義**
  - フロントエンドコードからは `settings` APIを経由して更新していることは確認できるが、実際のデータベーススキーマ定義ファイルを直接確認していない
  - 候補: `ghost/core/core/server/data/schema/` / データベースマイグレーションファイル / Knexスキーマ定義

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、イベント処理フロー
- **1（中リスク）**: settingsテーブル構造の詳細（APIレイヤーは確認済み、DB層は未確認）

## 6) レビュアーチェックリスト（最小）

- [ ] Private features一覧が最新のソースコードと一致しているか確認
- [ ] settingsテーブルのlabsカラム仕様をDBスキーマで確認
- [ ] limiterの制限対象機能が正確に記載されているか確認
