---
generated_at: 2026-01-29 21:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：62-履歴・監査ログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **actionsテーブル構造**：データベーススキーマの直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/history.tsx` - エントリポイント
- E-02: `apps/admin-x-settings/src/components/settings/advanced/history-modal.tsx` - 履歴モーダル
- E-03: `apps/admin-x-framework/src/api/actions.ts` - Actions API定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 履歴・監査ログ画面はシステムイベントログを表示する | E-01 (15行目: description), E-02 | ○ |
| C-02 | View historyボタンでモーダルを開く | E-01 (14行目: Button onClick) | ○ |
| C-03 | モーダルのルートは history/view である | E-01 (9行目: updateRoute), E-02 (202行目) | ○ |
| C-04 | 無限スクロールで追加データを取得する | E-02 (229行目: InfiniteScrollListener) | ○ |
| C-05 | PAGE_SIZEは200である | E-02 (161行目: PAGE_SIZE = 200) | ○ |
| C-06 | イベントタイプでフィルタリングできる（added/edited/deleted） | E-02 (83-85行目: HistoryFilterToggle) | ○ |
| C-07 | リソースタイプでフィルタリングできる | E-02 (87-93行目: HistoryFilterToggle) | ○ |
| C-08 | スタッフで検索・フィルタリングできる | E-02 (65-69行目: useFilterableApi, 96-113行目: Select) | ○ |
| C-09 | Action型にはid, resource_id, event, context等が含まれる | E-03 (8-32行目: Action type) | ○ |
| C-10 | contextはJSON文字列として保存され、取得時にパースされる | E-03 (54-59行目: JSON.parse) | ○ |
| C-11 | 連続した同一アクションはグループ化される | E-03 (62-79行目: skip, count) | ○ |
| C-12 | アクションアイコンはイベントタイプで変わる（add/pen/trash） | E-02 (10-23行目: HistoryIcon) | ○ |
| C-13 | labelリソースタイプはデフォルトで非表示 | E-02 (168行目: excludedResources初期値) | ○ |
| C-14 | フィルターなしで該当なしの場合「No history entries found.」を表示 | E-02 (265行目: NoValueLabel) | ○ |
| C-15 | フィルター適用時に該当なしの場合「No entries match your current filters.」を表示 | E-02 (254-256行目: NoValueLabel条件分岐) | ○ |
| C-16 | 終端到達時「End of history log」を表示 | E-02 (225行目: hint) | ○ |
| C-17 | getLinkTargetでリソースへのリンクを生成する | E-03 (116-176行目: getLinkTarget) | ○ |
| C-18 | getActionTitleでアクションタイトルを生成する | E-03 (178-210行目: getActionTitle) | ○ |
| C-19 | 関連機能No.35は一般設定である | E-04 (履歴・監査ログ行) | ○ |
| C-20 | actionsテーブルにはresource_type, actor_type, event, created_at等のカラムがある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **actionsテーブルのスキーマ定義**
  - フロントエンドコードからAction型の構造は確認できるが、実際のデータベーススキーマ定義ファイルを直接確認していない
  - 候補: `ghost/core/core/server/data/schema/` / データベースマイグレーションファイル

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、フィルター機能、無限スクロール実装
- **1（中リスク）**: actionsテーブル構造の詳細（API層は確認済み、DB層は未確認）

## 6) レビュアーチェックリスト（最小）

- [ ] actionsテーブルのスキーマがAction型と一致しているか確認
- [ ] リソースタイプの一覧が最新のGhostバージョンと整合しているか確認
- [ ] ユーザー検索APIのエンドポイントが正しいか確認
