---
generated_at: 2026-01-29 21:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：63-危険ゾーン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **削除対象テーブルの詳細**：バックエンド実装の直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/admin-x-settings/src/components/settings/advanced/danger-zone.tsx` - Danger zone画面
- E-02: `apps/admin-x-framework/src/api/db.ts` - DB API定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 危険ゾーン画面は全コンテンツを削除する機能を提供する | E-01 (39行目: description), E-01 (46行目: Button label) | ○ |
| C-02 | ナビゲーションIDは'dangerzone'である | E-01 (42行目: navid='dangerzone') | ○ |
| C-03 | Delete all contentボタンは赤色である | E-01 (46行目: color='red') | ○ |
| C-04 | ConfirmationModalで確認ダイアログを表示する | E-01 (15行目: NiceModal.show(ConfirmationModal)) | ○ |
| C-05 | 確認ダイアログのタイトルは「Would you really like to delete all content from your blog?」 | E-01 (16行目: title) | ○ |
| C-06 | 確認ダイアログの警告文は「This is permanent! No backups...」 | E-01 (17行目: prompt) | ○ |
| C-07 | 確認ダイアログの削除ボタンは赤色（okColor: 'red'） | E-01 (18行目: okColor) | ○ |
| C-08 | deleteAllContent APIを呼び出す | E-01 (22行目: await deleteAllContent(null)) | ○ |
| C-09 | 成功時に「All content deleted from database.」トーストを表示 | E-01 (23-26行目: showToast) | ○ |
| C-10 | 成功時にモーダルを閉じる | E-01 (27行目: modal?.remove()) | ○ |
| C-11 | 成功時に全クエリキャッシュをリフレッシュする | E-01 (28行目: await client.refetchQueries()) | ○ |
| C-12 | 失敗時にhandleErrorでエラー処理する | E-01 (29-30行目: catch, handleError(e)) | ○ |
| C-13 | APIエンドポイントはDELETE /db/である | E-02 (14-17行目: method: 'DELETE', path: '/db/') | ○ |
| C-14 | 関連機能No.65はデータベース管理である | E-03 (危険ゾーン行) | ○ |
| C-15 | 削除対象はposts, tags, posts_tags, posts_authorsテーブルである | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **削除対象テーブルの詳細なリスト**
  - フロントエンドコードからは `/db/` への DELETE リクエストのみ確認可能
  - 実際に削除されるテーブル・データの詳細はバックエンド実装を確認する必要がある
  - 候補: `ghost/core/core/server/api/endpoints/db.js` / `ghost/core/core/server/data/db/`

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、確認ダイアログ表示
- **1（中リスク）**: 削除対象データの範囲（posts, tagsのみか、関連データも含むか）
- **2（高リスク）**: この機能は不可逆な破壊的操作のため、テスト環境での十分な検証が必要

## 6) レビュアーチェックリスト（最小）

- [ ] バックエンドの /db/ DELETE エンドポイント実装で削除対象テーブルを確認
- [ ] メンバー、設定、スタッフユーザーが削除されないことを確認
- [ ] 削除操作の権限チェックがバックエンドで適切に行われているか確認
