---
generated_at: 2026-01-29 21:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-ActivityPubリーダー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/inbox/inbox.tsx` - Inboxメインコンポーネント
- E-02: `apps/activitypub/src/views/inbox/components/inbox-list.tsx` - 一覧表示コンポーネント
- E-03: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ActivityPubリーダー画面はフォローしているアカウントの投稿を表示する | E-01 (11行目: useInboxForUser) | ○ |
| C-02 | URLパスは /activitypub/reader である | E-03 (34-37行目: path: 'reader') | ○ |
| C-03 | ページタイトルは「Reader」である | E-03 (36行目: pageTitle: 'Reader') | ○ |
| C-04 | トピックのデフォルトは 'following' である | E-01 (9行目: useState<Topic>('following')) | ○ |
| C-05 | トピックが 'following' の場合は useInboxForUser を使用 | E-01 (11行目: enabled: topic === 'following') | ○ |
| C-06 | トピックが 'following' 以外の場合は useDiscoveryFeedForUser を使用 | E-01 (12行目: enabled: topic !== 'following') | ○ |
| C-07 | トピック404エラーは空配列として扱う | E-01 (17行目: topicNotFound判定, 23行目: []) | ○ |
| C-08 | 無限スクロールはIntersectionObserverで実装 | E-02 (44-72行目: observerRef, IntersectionObserver) | ○ |
| C-09 | ロードトリガー位置はリストの約75%地点 | E-02 (75行目: Math.floor(activities.length * 0.75)) | ○ |
| C-10 | 記事クリックで /reader/{postId} へ遷移 | E-02 (107行目: navigate('/reader/...')) | ○ |
| C-11 | Readerモーダルはフルスクリーン表示 | E-02 (176行目: h-[calc(100vh-24px)]) | ○ |
| C-12 | 空フィード時に「Your Reader is empty」を表示 | E-02 (155行目: title="Your Reader is empty") | ○ |
| C-13 | 空フィード時に「Find accounts to follow」ボタンを表示 | E-02 (143-152行目: Button) | ○ |
| C-14 | トピック別空フィード時に「Nothing here yet」を表示 | E-02 (133行目: title="Nothing here yet") | ○ |
| C-15 | TopicFilterでトピック切り替えが可能 | E-02 (79行目: TopicFilter, onTopicChange) | ○ |
| C-16 | APIエラー時はAppErrorコンポーネントを表示 | E-01 (18-20行目: isApiError判定, AppError) | ○ |
| C-17 | FeedItemクリックでナビゲーション実行 | E-02 (106-108行目: onClick) | ○ |
| C-18 | 関連機能No.57はActivityPubである | E-04 (ActivityPubリーダー画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、無限スクロール実装
- **0（低リスク）**: トピック切り替えロジック、エラーハンドリング

## 6) レビュアーチェックリスト（最小）

- [ ] トピック一覧が最新のAPIレスポンスと一致しているか確認
- [ ] Readerモーダル内の記事表示レイアウトの詳細確認
- [ ] いいね・リポスト操作の楽観的更新ロジックの確認
