---
generated_at: 2026-01-29 21:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-ノート一覧画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/feed/feed.tsx` - Feedメインコンポーネント
- E-02: `apps/activitypub/src/views/feed/components/feed-list.tsx` - 一覧表示コンポーネント
- E-03: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ノート一覧画面はフォロー中アカウントの短文投稿を表示する | E-01 (11行目: useFeedForUser) | ○ |
| C-02 | URLパスは /activitypub/notes である | E-03 (44-47行目: path: 'notes') | ○ |
| C-03 | ページタイトルは「Notes」である | E-03 (46行目: pageTitle: 'Notes') | ○ |
| C-04 | useFeedForUserでフィードデータを取得する | E-01 (11行目: useFeedForUser) | ○ |
| C-05 | 無限スクロールはIntersectionObserverで実装 | E-02 (33-61行目: observerRef, IntersectionObserver) | ○ |
| C-06 | ロードトリガー位置はリストの約75%地点 | E-02 (63行目: Math.floor(activities.length * 0.75)) | ○ |
| C-07 | FeedInputコンポーネントで投稿入力を行う | E-02 (74行目: FeedInput) | ○ |
| C-08 | ノートクリックで /notes/{postId} へ遷移 | E-02 (94-96行目: navigate('/notes/...')) | ○ |
| C-09 | SuggestedProfilesは4番目の位置に挿入される | E-02 (101-103行目: index === 3) | ○ |
| C-10 | 空フィード時に説明メッセージを表示 | E-02 (126-128行目: EmptyViewIndicator) | ○ |
| C-11 | 空フィード時に「Write your first note」ボタンを表示 | E-02 (129-132行目: Button) | ○ |
| C-12 | NewNoteModalでノート投稿モーダルを表示 | E-02 (128-132行目: NewNoteModal) | ○ |
| C-13 | isPendingActivityでpending状態をチェック | E-02 (88行目: isPendingActivity) | ○ |
| C-14 | APIエラー時はAppErrorコンポーネントを表示 | E-01 (18-19行目: isApiError, AppError) | ○ |
| C-15 | useUserDataForUserでユーザー情報を取得 | E-01 (16行目: useUserDataForUser) | ○ |
| C-16 | 関連機能No.57はActivityPubである | E-04 (ノート一覧画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、無限スクロール実装
- **0（低リスク）**: 投稿フォーム、おすすめプロフィール表示

## 6) レビュアーチェックリスト（最小）

- [ ] ノート投稿の楽観的更新ロジックの詳細確認
- [ ] NewNoteModalの投稿処理フローの確認
- [ ] SuggestedProfilesのデータ取得元の確認
