---
generated_at: 2026-01-29 21:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-ノート詳細画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/feed/note.tsx` - Noteメインコンポーネント
- E-02: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ノート詳細画面は個別ノートと返信スレッドを表示する | E-01 (全体構造) | ○ |
| C-02 | URLパスは /activitypub/notes/:postId である | E-02 (49-52行目: path: 'notes/:postId') | ○ |
| C-03 | ページタイトルは「Note」である | E-02 (51行目: pageTitle: 'Note') | ○ |
| C-04 | useReplyChainDataでリプライチェーンを取得する | E-01 (38-47行目: useReplyChainData) | ○ |
| C-05 | includeAncestors: trueで親投稿も取得する | E-01 (47行目: includeAncestors: true) | ○ |
| C-06 | threadParentsが存在する場合は自動スクロールする | E-01 (54-62行目: scrollIntoView) | ○ |
| C-07 | IntersectionObserverで追加読み込みをトリガーする | E-01 (64-100行目: IntersectionObserver) | ○ |
| C-08 | rootMarginは200pxである | E-01 (86-88行目: rootMargin: '200px') | ○ |
| C-09 | toggleChainでチェーン展開/折りたたみを行う | E-01 (149-164行目: toggleChain) | ○ |
| C-10 | expandedChainsで展開状態を管理する | E-01 (28行目: useState<Set<string>>()) | ○ |
| C-11 | fullyExpandedChainsで完全展開状態を管理する | E-01 (29行目: useState<Set<string>>()) | ○ |
| C-12 | 削除済みノートはDeletedFeedItemで表示する | E-01 (218-219行目: Tombstone判定, DeletedFeedItem) | ○ |
| C-13 | ノート取得失敗時に「Error loading note.」を表示 | E-01 (133-142行目: EmptyViewIndicator) | ○ |
| C-14 | APReplyBoxで返信入力を行う | E-01 (253-255行目: APReplyBox) | ○ |
| C-15 | ShowRepliesButtonで展開/追加読み込みを行う | E-01 (338-350行目: ShowRepliesButton) | ○ |
| C-16 | isPendingActivityでpending状態をチェック | E-01 (274行目: isPendingActivity) | ○ |
| C-17 | allowDeleteは自分のノートの場合のみtrue | E-01 (271行目: allowDelete={...object.authored}) | ○ |
| C-18 | 関連機能No.57はActivityPubである | E-03 (ノート詳細画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、スクロール処理
- **0（低リスク）**: チェーン展開/折りたたみロジック

## 6) レビュアーチェックリスト（最小）

- [ ] useReplyChainDataの詳細実装の確認
- [ ] 削除操作のフローと確認ダイアログの確認
- [ ] 返信投稿の楽観的更新ロジックの確認
