---
generated_at: 2026-01-29 22:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-通知画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/notifications/notifications.tsx` - Notificationsメインコンポーネント
- E-02: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知画面はActivityPubネットワークからの通知を表示する | E-01 (219行目: useNotificationsForUser) | ○ |
| C-02 | URLパスは /activitypub/notifications である | E-02 (54-57行目: path: 'notifications') | ○ |
| C-03 | ページタイトルは「Notifications」である | E-02 (56行目: pageTitle: 'Notifications') | ○ |
| C-04 | 24時間単位の時間バケットでグループ化される | E-01 (40-46行目: getTimeBucket, TIME_WINDOW_MS = 24 * 60 * 60 * 1000) | ○ |
| C-05 | 連続した同タイプ通知はグループ化される（sequenceCounter） | E-01 (53-62行目: sequenceCounter) | ○ |
| C-06 | reply/mentionはグループ化されない | E-01 (75-77, 87-89行目: 個別groupKey) | ○ |
| C-07 | 最大5件のアバターを表示 | E-01 (217行目: maxAvatars = 5, 335行目: slice(0, maxAvatars)) | ○ |
| C-08 | フォロー通知にはフォローバックボタンが表示される | E-01 (388-394, 420-426行目: FollowButton) | ○ |
| C-09 | 空通知時に「Quiet for now, but not for long!」を表示 | E-01 (296行目: EmptyViewIndicator内のテキスト) | ○ |
| C-10 | toggleOpenでグループ展開/折りたたみを行う | E-01 (205-209行目: toggleOpen) | ○ |
| C-11 | like通知クリックで投稿詳細へ遷移 | E-01 (256-258行目: navigate to reader/notes) | ○ |
| C-12 | follow通知クリックでプロフィールへ遷移またはグループ展開 | E-01 (270-275行目: 条件分岐) | ○ |
| C-13 | IntersectionObserverで無限スクロールを実装 | E-01 (228-251行目: observerRef, IntersectionObserver) | ○ |
| C-14 | NotificationGroupDescriptionでアクション説明を表示 | E-01 (112-154行目: NotificationGroupDescription) | ○ |
| C-15 | APIエラー時はAppErrorコンポーネントを表示 | E-01 (285-287行目: isApiError, AppError) | ○ |
| C-16 | 関連機能No.57はActivityPubである | E-03 (通知画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、グループ化ロジック
- **0（低リスク）**: 通知タイプ別の遷移先判定

## 6) レビュアーチェックリスト（最小）

- [ ] グループ化ロジックの境界条件（24時間またぎ等）の確認
- [ ] フォローバック操作のエラーハンドリングの確認
- [ ] 通知アイコンの種類と表示条件の確認
