---
generated_at: 2026-01-29 22:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-探索画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/explore/explore.tsx` - Exploreメインコンポーネント
- E-02: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 探索画面はおすすめアカウントを表示する | E-01 (108行目: useExploreProfilesForUserByTopic) | ○ |
| C-02 | URLパスは /activitypub/explore である | E-02 (59-62行目: path: 'explore') | ○ |
| C-03 | ページタイトルは「Explore」である | E-02 (61行目: pageTitle: 'Explore') | ○ |
| C-04 | デフォルトトピックは「top」である | E-01 (106行目: topic || 'top') | ○ |
| C-05 | トピックが「top」の場合はURLに含まれない | E-01 (160-161行目: navigate('/explore')) | ○ |
| C-06 | 「following」トピックは除外される | E-01 (158行目: excludeTopics={['following']}) | ○ |
| C-07 | IntersectionObserverで無限スクロールを実装 | E-01 (123-140行目: IntersectionObserver) | ○ |
| C-08 | threshold: 0.1で検知 | E-01 (135行目: threshold: 0.1) | ○ |
| C-09 | 説明バナーはuseOnboardingStatusで管理される | E-01 (102行目: useOnboardingStatus) | ○ |
| C-10 | アカウントクリックでプロフィール画面へ遷移 | E-01 (46-47行目: navigate('/profile/{handle}')) | ○ |
| C-11 | フォロー状態はupdateExploreProfileで更新される | E-01 (28-37行目: onFollow, onUnfollow, update) | ○ |
| C-12 | バイオは2行まで表示される | E-01 (92行目: line-clamp-2) | ○ |
| C-13 | ProfilePreviewHoverCardでホバープレビュー表示 | E-01 (51行目: ProfilePreviewHoverCard) | ○ |
| C-14 | 自分自身の場合はフォローボタンを非表示 | E-01 (68-78行目: !isCurrentUser条件) | ○ |
| C-15 | 関連機能No.57はActivityPubである | E-03 (探索画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、無限スクロール実装
- **0（低リスク）**: トピックフィルタリング、フォロー操作

## 6) レビュアーチェックリスト（最小）

- [ ] トピック一覧がAPIレスポンスと一致しているか確認
- [ ] 説明バナーの永続化ロジック（useOnboardingStatus）の確認
- [ ] フォロー操作の楽観的更新ロジックの確認
