---
generated_at: 2026-01-29 22:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-プロフィール画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/profile/profile.tsx` - Profileメインコンポーネント
- E-02: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロフィール画面はActivityPubアカウント情報を表示する | E-01 (143行目: useAccountForUser) | ○ |
| C-02 | URLパスは /activitypub/profile である | E-02 (69-72行目: path: 'profile') | ○ |
| C-03 | ページタイトルは「Profile」である | E-02 (71行目: pageTitle: 'Profile') | ○ |
| C-04 | 自分のプロフィールは handle='me' でアクセス | E-01 (143行目: params.handle || 'me') | ○ |
| C-05 | PostsTabでusePostsByAccountを使用 | E-01 (17行目: usePostsByAccount) | ○ |
| C-06 | LikesTabでusePostsLikedByAccountを使用 | E-01 (40行目: usePostsLikedByAccount) | ○ |
| C-07 | FollowingTabでuseAccountFollowsForUser('following')を使用 | E-01 (55行目: useAccountFollowsForUser) | ○ |
| C-08 | FollowersTabでuseAccountFollowsForUser('followers')を使用 | E-01 (99行目: useAccountFollowsForUser) | ○ |
| C-09 | カスタムフィールドはObject.keysで動的に生成 | E-01 (153-158行目: Object.keys) | ○ |
| C-10 | handle変更時にrefetchを実行 | E-01 (145-147行目: useEffect, refetch) | ○ |
| C-11 | 404以外のAPIエラーでAppErrorを表示 | E-01 (149-151行目: statusCode !== 404) | ○ |
| C-12 | 投稿がない場合のメッセージを表示 | E-01 (34行目: noResultsMessage) | ○ |
| C-13 | フォロー中がいない場合のメッセージを表示 | E-01 (93行目: noResultsMessage) | ○ |
| C-14 | blockedByMe, domainBlockedByMeでブロック状態をチェック | E-01 (79-80行目: blockedByMe, domainBlockedByMe) | ○ |
| C-15 | URLにタブパラメータが含まれる（likes/following/followers） | E-02 (74-86行目: path: 'profile/likes'等) | ○ |
| C-16 | 関連機能No.57はActivityPubである | E-03 (プロフィール画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、タブ切り替え
- **0（低リスク）**: データ取得フック、エラーハンドリング

## 6) レビュアーチェックリスト（最小）

- [ ] プロフィール編集機能の詳細実装確認
- [ ] ブロック/アンブロック操作のフロー確認
- [ ] Likesタブの表示条件（自分のみ）の確認
