---
generated_at: 2026-01-29 22:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-ActivityPub設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/preferences/preferences.tsx` - Preferencesメインコンポーネント
- E-02: `apps/activitypub/src/views/preferences/components/settings.tsx` - 設定一覧コンポーネント
- E-03: `apps/activitypub/src/routes.tsx` - ルーティング定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 設定画面はActivityPub設定を一元管理する | E-01 (全体構造) | ○ |
| C-02 | URLパスは /activitypub/preferences である | E-03 (94-97行目: path: 'preferences') | ○ |
| C-03 | ページタイトルは「Preferences」である | E-03 (96行目: pageTitle: 'Preferences') | ○ |
| C-04 | useAccountForUser('me')でアカウント情報を取得 | E-01 (10行目: useAccountForUser('index', 'me')) | ○ |
| C-05 | Account設定でEditProfileダイアログを表示 | E-02 (27-37行目: Dialog, EditProfile) | ○ |
| C-06 | Moderation設定でnavigate('/preferences/moderation')を実行 | E-02 (39行目: onClick={() => navigate('/preferences/moderation')}) | ○ |
| C-07 | Bluesky sharing設定でnavigate('/preferences/bluesky-sharing')を実行 | E-02 (48行目: onClick={() => navigate('/preferences/bluesky-sharing')}) | ○ |
| C-08 | Bluesky状態はaccount.blueskyEnabledで判定 | E-02 (54行目: account?.blueskyEnabled) | ○ |
| C-09 | Help設定は外部リンク（ghost.org/help/social-web/） | E-02 (59行目: href='https://ghost.org/help/social-web/') | ○ |
| C-10 | モデレーション画面はshowBackButton: true | E-03 (102行目: showBackButton: true) | ○ |
| C-11 | Bluesky共有画面はshowBackButton: true | E-03 (106行目: showBackButton: true) | ○ |
| C-12 | APIエラー時はAppErrorを表示 | E-01 (12-14行目: isApiError, AppError) | ○ |
| C-13 | Layout内にProfileとSettingsを配置 | E-01 (17-22行目: Layout, Profile, Settings) | ○ |
| C-14 | 関連機能No.57はActivityPubである | E-04 (設定画面行) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: UIコンポーネント構造、ルーティング、ナビゲーション
- **0（低リスク）**: 設定項目一覧、外部リンク

## 6) レビュアーチェックリスト（最小）

- [ ] EditProfileコンポーネントの詳細実装確認
- [ ] モデレーション設定画面の機能確認
- [ ] Bluesky共有設定画面の機能確認
