---
generated_at: 2026-01-29 20:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-モデレーション設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：権限チェックのコードが直接確認できなかった

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/preferences/components/moderation.tsx` L1-211
- E-02: `apps/activitypub/src/routes.tsx` L99-103
- E-03: `apps/activitypub/src/hooks/use-activity-pub-queries.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L72
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L107

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はActivityPubモデレーション設定を管理する | E-01 L1-13, E-04 | ○ |
| C-02 | URLパスは `/activitypub/preferences/moderation` | E-02 L99-103 | ○ |
| C-03 | ブロック済みユーザーとドメインの2つのタブがある | E-01 L90-94 | ○ |
| C-04 | ブロック済みユーザー一覧を表示する | E-01 L14, L104-157 | ○ |
| C-05 | ブロック済みドメイン一覧を表示する | E-01 L15, L160-202 | ○ |
| C-06 | ユーザーのアンブロック機能がある | E-01 L35-45 | ○ |
| C-07 | ユーザーの再ブロック機能がある | E-01 L47-57 | ○ |
| C-08 | ドメインのアンブロック機能がある | E-01 L59-69 | ○ |
| C-09 | ドメインの再ブロック機能がある | E-01 L71-81 | ○ |
| C-10 | 成功時にトースト通知を表示する | E-01 L44, L56, L68, L80 | ○ |
| C-11 | 空状態時にメッセージを表示する | E-01 L96-102, L161-167 | ○ |
| C-12 | ホバー時にボタンテキストが変化する | E-01 L145-148, L191-194 | ○ |
| C-13 | 読み込み中はスケルトン表示する | E-01 L17-22, L121-122, L150-152 | ○ |
| C-14 | ProfilePreviewHoverCardでプレビュー表示 | E-01 L105 | ○ |
| C-15 | プロフィールクリックで遷移する | E-01 L108 | ○ |
| C-16 | 機能Noは57（ActivityPub）と関連 | E-05 L107 | ○ |
| C-17 | 楽観的UI更新を使用している | E-01 L36-40, L48-52 | ○ |
| C-18 | 管理者権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- 権限チェックに関する詳細なコードが直接確認できなかった
  - 候補：`apps/activitypub/src/App.tsx` / 認証ラッパーコンポーネント / Ghost Admin側の権限設定

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 大部分の主張はソースコードで裏付けられている
- 1: 中リスク - 権限制御の詳細については追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] 権限制御の実装を別途確認する
- [ ] APIエンドポイントの仕様を確認する
- [ ] エラーハンドリングの網羅性を確認する
