---
generated_at: 2026-01-29 20:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-Bluesky共有設定画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/views/preferences/components/bluesky-sharing.tsx` L1-271
- E-02: `apps/activitypub/src/routes.tsx` L104-108
- E-03: `apps/activitypub/src/hooks/use-activity-pub-queries.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L73
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L108

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はBluesky連携設定を管理する | E-01 L30, E-04 | ○ |
| C-02 | URLパスは `/activitypub/preferences/bluesky-sharing` | E-02 L105 | ○ |
| C-03 | Bridgy Fed経由で連携する | E-01 L161, L195 | ○ |
| C-04 | アバター未設定時はプロフィール編集を促す | E-01 L49-50, L159-160 | ○ |
| C-05 | 有効化ボタンでBluesky共有を開始 | E-01 L178-187 | ○ |
| C-06 | 無効化時に確認ダイアログを表示 | E-01 L239-265 | ○ |
| C-07 | ハンドルをコピーできる | E-01 L42-46, L219-224 | ○ |
| C-08 | 外部リンクでBlueskyプロフィールを開く | E-01 L227-232 | ○ |
| C-09 | ポーリング間隔は5秒 | E-01 L27 (CONFIRMATION_INTERVAL = 5000) | ○ |
| C-10 | 最大12回リトライ | E-01 L28 (MAX_CONFIRMATION_RETRIES = 12) | ○ |
| C-11 | タイムアウト時にエラートースト表示 | E-01 L114 | ○ |
| C-12 | タイムアウト時に自動無効化 | E-01 L116 | ○ |
| C-13 | 有効化成功時にトースト表示 | E-01 L97 | ○ |
| C-14 | 無効化成功時にトースト表示 | E-01 L67 | ○ |
| C-15 | ローディング中は処理中メッセージ表示 | E-01 L182-185, L188-190 | ○ |
| C-16 | ハンドル変更不可の警告を表示 | E-01 L163 | ○ |
| C-17 | 有効化済み時は緑バッジを表示 | E-01 L151-152 | ○ |
| C-18 | ホバーでDisableボタン表示 | E-01 L151-155 | ○ |
| C-19 | 機能Noは57（ActivityPub）と関連 | E-05 L108 | ○ |
| C-20 | 確認完了時にプロフィール情報を表示 | E-01 L196-234 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] Bridgy Fed APIの仕様を確認する
- [ ] ポーリングタイムアウト時のユーザー体験を確認する
- [ ] エラーハンドリングの網羅性を確認する
