---
generated_at: 2026-01-29 20:52:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-ウェルカム画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/activitypub/src/components/layout/onboarding/onboarding.tsx` L1-58
- E-02: `apps/activitypub/src/components/layout/onboarding/step-1.tsx` L1-104
- E-03: `apps/activitypub/src/components/layout/onboarding/step-2.tsx` L1-164
- E-04: `apps/activitypub/src/components/layout/onboarding/step-3.tsx` L1-393
- E-05: `apps/activitypub/src/routes.tsx` L110-134
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` L74
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L109

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は3ステップのオンボーディングフロー | E-05 L119-129 | ○ |
| C-02 | URLパスは `/activitypub/welcome/1` から開始 | E-05 L110, L119 | ○ |
| C-03 | 無効なパスはStep 1へリダイレクト | E-05 L116, L131-133 | ○ |
| C-04 | Step 1でソーシャルウェブハンドルを表示 | E-02 L38-79 | ○ |
| C-05 | ハンドルのコピー機能がある | E-02 L25-29 | ○ |
| C-06 | Step 2でインタラクション説明を表示 | E-03 L67-159 | ○ |
| C-07 | Step 3でコンテンツタイプを紹介 | E-04 L80-298 | ○ |
| C-08 | タブが3秒ごとに自動切替 | E-04 L309-318 | ○ |
| C-09 | ホバー中はタブ切替停止 | E-04 L310-312 | ○ |
| C-10 | オンボーディング完了でsetOnboarded(true) | E-04 L321-324 | ○ |
| C-11 | トピックありで/exploreへ遷移 | E-04 L323 | ○ |
| C-12 | トピックなしで/へ遷移 | E-04 L323 | ○ |
| C-13 | useOnboardingStatusで状態管理 | E-01 L7-47 | ○ |
| C-14 | accessibilityにオンボーディング状態保存 | E-01 L11-17, L24-38 | ○ |
| C-15 | useBrowseUsersで著者一覧取得 | E-02 L12 | ○ |
| C-16 | ダークモード対応の背景画像 | E-02 L47-48 | ○ |
| C-17 | Reply/Like/Repostのモックアップ表示 | E-03 L10-65 (Reply, Reaction components) | ○ |
| C-18 | フォロワー数バッジのアニメーション | E-03 L87-89 | ○ |
| C-19 | Long form/Short form/Readerタブ | E-04 L347-370 | ○ |
| C-20 | プロフィールカードにbio表示 | E-02 L81-87 | ○ |
| C-21 | 著者情報をアバター集約で表示 | E-02 L89-95 | ○ |
| C-22 | 機能Noは57（ActivityPub）と関連 | E-07 L109 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] オンボーディング完了後の再アクセス挙動を確認する
- [ ] アニメーションのパフォーマンスを確認する
- [ ] モバイルデバイスでの表示を確認する（最小幅1240pxの背景画像対応）
