---
generated_at: 2026-01-29 20:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-Explore画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/explore.js` L1-11
- E-02: `ghost/admin/app/services/explore.js` L1-137
- E-03: `ghost/admin/app/controllers/explore.js` L1-59
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L75
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L110

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | iframeでGhost Exploreを埋め込み表示 | E-02 L127-131 (ensureIframeIsLoaded), L133-135 (getExploreIframe) | ○ |
| C-02 | URLパスは `/explore` | E-01, E-02 L13 (exploreRouteRoot) | ○ |
| C-03 | ExploreサービスでExplore URL定義 | E-02 L12 (exploreUrl = 'https://ghost.org/explore/') | ○ |
| C-04 | postMessage APIで通信 | E-02 L47-53, L74-81 | ○ |
| C-05 | iframeルート変更をハンドル | E-02 L56-71 (handleRouteChangeInIframe) | ○ |
| C-06 | ブラウザ履歴を同期 | E-02 L68-69 (window.history.replaceState) | ○ |
| C-07 | Force Upgrade時はiframeを開かない | E-02 L94-97, L107-110 | ○ |
| C-08 | openExploreWindowでウィンドウを開く | E-02 L106-125 | ○ |
| C-09 | toggleExploreWindowで表示制御 | E-02 L93-104 | ○ |
| C-10 | integrationモデルを取得 | E-01 L7-9 | ○ |
| C-11 | AuthenticatedRouteを継承 | E-01 L4 | ○ |
| C-12 | ghost-exploreインテグレーションを使用 | E-03 L11-16 | ○ |
| C-13 | submitRouteの定義 | E-02 L14 (submitRoute = 'submit') | ○ |
| C-14 | apiUrlの生成 | E-02 L20-27 | ○ |
| C-15 | 機能Noは91（Explore連携）と関連 | E-05 L110 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている
- 1: 中リスク - iframe内のコンテンツは外部サービス（Ghost Explore）が管理するため、その部分の仕様は本設計書の範囲外

## 6) レビュアーチェックリスト（最小）

- [ ] Ghost Exploreサービスの仕様変更による影響を確認する
- [ ] postMessage通信のセキュリティを確認する
- [ ] iframe読み込み失敗時のエラーハンドリングを確認する
