---
generated_at: 2026-01-29 20:58:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-Explore接続画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/explore/connect.js` L1-11
- E-02: `ghost/admin/app/templates/explore/connect.hbs` L1-34
- E-03: `ghost/admin/app/controllers/explore.js` L1-59
- E-04: `ghost/admin/app/services/explore.js` L1-137
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` L76
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L111

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/explore/connect` | E-01 L3 (ExploreRouteを継承) | ○ |
| C-02 | beforeModelでiframeを閉じる | E-01 L7-8 | ○ |
| C-03 | Ghost Orbロゴを表示 | E-02 L10 (svg-jar "ghost-orb-pink") | ○ |
| C-04 | ヘッドラインを表示 | E-02 L11 | ○ |
| C-05 | API URLを表示 | E-02 L12 | ○ |
| C-06 | 3つの許可説明を表示 | E-02 L15-27 | ○ |
| C-07 | 接続ボタンを表示 | E-02 L30-32 | ○ |
| C-08 | 閉じるボタンを表示 | E-02 L3-6 | ○ |
| C-09 | ghost-exploreインテグレーションからトークン取得 | E-03 L11-16 | ○ |
| C-10 | closeConnectでiframeモードの処理 | E-03 L24-26 | ○ |
| C-11 | closeConnectで外部モードの処理 | E-03 L27-28 | ○ |
| C-12 | submitExploreSiteでクエリパラメータ構築 | E-03 L36-40 | ○ |
| C-13 | iframeモードでsendRouteUpdate実行 | E-03 L42-43 | ○ |
| C-14 | iframeモードで500ms後にウィンドウ表示 | E-03 L45-48 | ○ |
| C-15 | 外部モードでwindow.location遷移 | E-03 L50-55 | ○ |
| C-16 | 機能Noは91（Explore連携）と関連 | E-06 L111 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] ghost-exploreインテグレーションが存在しない場合のエラーハンドリングを確認する
- [ ] トークンのセキュリティ（クエリパラメータでの送信）を確認する
- [ ] 500msタイムアウトの妥当性を確認する
