---
generated_at: 2026-01-29 21:02:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-マイグレーション画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/migrate.js` L1-17
- E-02: `ghost/admin/app/templates/migrate.hbs` L1-9
- E-03: `ghost/admin/app/services/migrate.js` L1-130
- E-04: `ghost/admin/app/components/gh-migrate-modal.js` L1-11
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` L77
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L112

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/migrate` | E-01 L4 | ○ |
| C-02 | 管理者以外はホームへリダイレクト | E-01 L11-13 | ○ |
| C-03 | isAdminで権限チェック | E-01 L12 | ○ |
| C-04 | migrateUrlはmigrate.ghost.org | E-03 L12 | ○ |
| C-05 | apiUrlを生成 | E-03 L21-28 | ○ |
| C-06 | self-serve-migrationインテグレーション使用 | E-03 L32-33 | ○ |
| C-07 | postMessagePayloadでペイロード構築 | E-03 L43-56 | ○ |
| C-08 | Stripe連携状態を送信 | E-03 L49, L58-59 | ○ |
| C-09 | ghostVersionを送信 | E-03 L50, L61-63 | ○ |
| C-10 | ownerEmailを送信 | E-03 L51 | ○ |
| C-11 | platformパラメータでURL生成 | E-03 L70-78 | ○ |
| C-12 | sendRouteUpdateでルート更新 | E-03 L82-87 | ○ |
| C-13 | toggleMigrateWindowで表示制御 | E-03 L92-98 | ○ |
| C-14 | closeMigrateWindowで/settings/migrationへ遷移 | E-03 L120-124 | ○ |
| C-15 | 閉じるボタンを表示 | E-02 L2-6 | ○ |
| C-16 | gh-migrate-modalコンポーネントを使用 | E-02 L8 | ○ |
| C-17 | migrateサービスで表示クラス制御 | E-04 L7-9 | ○ |
| C-18 | 機能Noは65（データベース管理）と関連 | E-06 L112 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] migrate.ghost.orgサービスの仕様変更による影響を確認する
- [ ] APIキーのセキュリティ（postMessageでの送信）を確認する
- [ ] self-serve-migrationインテグレーションが存在しない場合のエラーハンドリングを確認する
