---
generated_at: 2026-01-29 21:05:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：77-Pro画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ghost/admin/app/routes/pro.js` L1-60
- E-02: `ghost/admin/app/services/billing.js` L1-153
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` L78
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L113

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/pro` | E-01 L6, E-02 L12 | ○ |
| C-02 | queryParamsでactionを受け取る | E-01 L12-14 | ○ |
| C-03 | オーナーのみアクセス可能（通常時） | E-01 L20 | ○ |
| C-04 | Force Upgrade時は全ユーザーアクセス可能 | E-01 L20 | ○ |
| C-05 | 条件不一致時はhomeへリダイレクト | E-01 L21 | ○ |
| C-06 | previousTransitionを保存 | E-01 L23 | ○ |
| C-07 | modelでactionを設定 | E-01 L27-29 | ○ |
| C-08 | toggleProWindowでウィンドウ表示 | E-01 L31, E-02 L113-122 | ○ |
| C-09 | willTransitionで遷移制御 | E-01 L35-51 | ○ |
| C-10 | pageTitleは'Ghost(Pro)' | E-01 L54-57 | ○ |
| C-11 | billingRouteRootは'#/pro' | E-02 L12 | ○ |
| C-12 | postMessageでiframeと通信 | E-02 L23-29 | ○ |
| C-13 | handleRouteChangeInIframeでURL同期 | E-02 L31-43 | ○ |
| C-14 | getIframeURLでURL生成 | E-02 L50-65 | ○ |
| C-15 | sendRouteUpdateでルート更新 | E-02 L84-97 | ○ |
| C-16 | sendUpdateLimitsで制限更新 | E-02 L99-108 | ○ |
| C-17 | 機能Noは69（制限管理）と関連 | E-04 L113 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている
- 1: 中リスク - Billing Management Applicationの仕様は外部依存

## 6) レビュアーチェックリスト（最小）

- [ ] config.hostSettings.billing.urlの設定を確認する
- [ ] Force Upgrade状態の判定ロジックを確認する
- [ ] postMessage通信のセキュリティを確認する
