---
generated_at: 2026-01-29 21:08:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-サインインページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/portal/src/components/pages/signin-page.js` L1-228
- E-02: `apps/portal/src/pages.js` L1-67
- E-03: `apps/portal/src/app-context.js` L1-21
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L79
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L114-115

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページ識別子は'signin' | E-02 L25 | ○ |
| C-02 | マジックリンク認証を使用 | E-01 L47 (doAction('signin')) | ○ |
| C-03 | メールアドレス入力フィールドがある | E-01 L69-78 | ○ |
| C-04 | phonenumberはスパム対策用隠しフィールド | E-01 L79-90 (hidden: true) | ○ |
| C-05 | ログイン済み時はaccountHomeへ遷移 | E-01 L23-29 | ○ |
| C-06 | ValidateInputFormでバリデーション | E-01 L38-41 | ○ |
| C-07 | doActionでsigninアクション実行 | E-01 L47 | ○ |
| C-08 | 処理中は'Sending login link...'表示 | E-01 L99 | ○ |
| C-09 | 失敗時は'Retry'表示 | E-01 L101-103 | ○ |
| C-10 | サインアップリンクを表示 | E-01 L119-134 | ○ |
| C-11 | isSigninAllowedでサインイン可否判定 | E-01 L140 | ○ |
| C-12 | メンバーシップ無効時はメッセージ表示 | E-01 L142-151 | ○ |
| C-13 | サイトアイコンを表示 | E-01 L172-188 | ○ |
| C-14 | InvitationIconを無効時に表示 | E-01 L183-185 | ○ |
| C-15 | CloseButtonコンポーネントを使用 | E-01 L217 | ○ |
| C-16 | brandColorでスタイリング | E-01 L112, L125 | ○ |
| C-17 | t()関数で国際化 | E-01 L72, L99, L102, L123等 | ○ |
| C-18 | Enterキーでサインイン実行 | E-01 L59-63 | ○ |
| C-19 | 機能Noは9（メンバー認証）と関連 | E-05 L114 | ○ |
| C-20 | 機能Noは71（Portal）と関連 | E-05 L115 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] マジックリンクのセキュリティを確認する
- [ ] スパム対策フィールドの有効性を確認する
- [ ] 国際化されたメッセージの完全性を確認する
