---
generated_at: 2026-01-29 21:12:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：79-サインアップページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/portal/src/components/pages/signup-page.js` L1-902
- E-02: `apps/portal/src/pages.js` L1-67
- E-03: `apps/portal/src/app-context.js` L1-21
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L80
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L116-118

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページ識別子は'signup' | E-02 L26 | ○ |
| C-02 | 名前フィールドはportal_name設定で制御 | E-01 L496, L525-536 | ○ |
| C-03 | メールアドレス入力フィールドがある | E-01 L500-509 | ○ |
| C-04 | phonenumberはスパム対策用隠しフィールド | E-01 L510-521 (hidden: true) | ○ |
| C-05 | ログイン済み時はaccountHomeへ遷移 | E-01 L363-369 | ○ |
| C-06 | 利用規約チェックボックスがある | E-01 L546-587 | ○ |
| C-07 | portal_signup_terms_htmlで規約テキスト設定 | E-01 L548-549 | ○ |
| C-08 | portal_signup_checkbox_requiredで必須化 | E-01 L396-397, L565 | ○ |
| C-09 | ProductsSectionでプラン選択UI | E-01 L631-652 | ○ |
| C-10 | 複数ニュースレターでNewsletterSelectionPage表示 | E-01 L425-429 | ○ |
| C-11 | doActionでsignupアクション実行 | E-01 L435 | ○ |
| C-12 | 処理中は'Sending...'表示 | E-01 L607 | ○ |
| C-13 | 失敗時は'Retry'表示 | E-01 L611-613 | ○ |
| C-14 | 招待制サイトでinvite-onlyメッセージ | E-01 L705-707, L788-801 | ○ |
| C-15 | 有料会員のみでpaid-members-onlyメッセージ | E-01 L710-711, L772-786 | ○ |
| C-16 | メンバーシップ無効でメッセージ表示 | E-01 L716-717, L804-817 | ○ |
| C-17 | フリートライアル説明を表示 | E-01 L654-664 | ○ |
| C-18 | sanitizeHtmlで規約HTMLをサニタイズ | E-01 L561 | ○ |
| C-19 | 利用規約エラー時にスクロール | E-01 L420-421 | ○ |
| C-20 | handleSelectPlanで5ms遅延 | E-01 L461-470 | ○ |
| C-21 | SiteTitleBackButtonを使用 | E-01 L878-889 | ○ |
| C-22 | サインインリンクを表示 | E-01 L666-685 | ○ |
| C-23 | 機能Noは8（メンバー登録）と関連 | E-05 L116 | ○ |
| C-24 | 機能Noは15（Tier管理）と関連 | E-05 L117 | ○ |
| C-25 | 機能Noは71（Portal）と関連 | E-05 L118 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] 利用規約のHTMLサニタイズが十分か確認する
- [ ] 複数ニュースレター選択フローのUXを確認する
- [ ] 各種条件（招待制、有料のみ等）の組み合わせを確認する
