---
generated_at: 2026-01-29 21:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-アカウントホームページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `apps/portal/src/components/pages/AccountHomePage/account-home-page.js` L1-55
- E-02: `apps/portal/src/components/pages/AccountHomePage/components/account-main.js` L1-23
- E-03: `apps/portal/src/components/pages/AccountHomePage/components/account-actions.js` L1-69
- E-04: `apps/portal/src/pages.js` L1-67
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` L81
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L119-121

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページ識別子は'accountHome' | E-04 L27 | ○ |
| C-02 | componentDidMountでメンバーシップ確認 | E-01 L12-15 | ○ |
| C-03 | メンバーシップ無効時にsignout | E-01 L16-17 | ○ |
| C-04 | 未ログイン時にsigninへリダイレクト | E-01 L19-25 | ○ |
| C-05 | handleSignoutでサインアウト処理 | E-01 L29-32 | ○ |
| C-06 | AccountMainとAccountFooterで構成 | E-01 L43-50 | ○ |
| C-07 | getSupportAddressでサポートアドレス取得 | E-01 L36 | ○ |
| C-08 | AccountMainにサブコンポーネント配置 | E-02 L10-17 | ○ |
| C-09 | openEditProfileでプロフィール編集へ遷移 | E-03 L30-34 | ○ |
| C-10 | hasMultipleNewslettersでメール設定表示制御 | E-03 L3, L10-24 | ○ |
| C-11 | hasCommentsEnabledでメール設定表示制御 | E-03 L3, L12 | ○ |
| C-12 | isEmailSuppressedでメール設定表示制御 | E-03 L3, L13 | ○ |
| C-13 | PaidAccountActionsで有料会員向け表示 | E-03 L59 | ○ |
| C-14 | EmailPreferencesActionコンポーネント | E-03 L60 | ○ |
| C-15 | EmailNewsletterActionコンポーネント | E-03 L61 | ○ |
| C-16 | 機能Noは10（メンバープロフィール）と関連 | E-06 L119 | ○ |
| C-17 | 機能Noは18（サブスクリプション管理）と関連 | E-06 L120 | ○ |
| C-18 | 機能Noは71（Portal）と関連 | E-06 L121 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）

- [ ] 各サブコンポーネントの表示条件を確認する
- [ ] 有料会員と無料会員の表示差異を確認する
- [ ] redirectパラメータの処理を確認する
