---
generated_at: 2026-01-29 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：81-プラン選択ページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25**：データベーステーブル構造の詳細（根拠不足）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/account-plan-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/pages.js` - ページルーティング定義
- E-03: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-04: `apps/portal/src/utils/api.js` - API通信処理
- E-05: `apps/portal/src/utils/helpers.js` - ヘルパー関数群
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AccountPlanPageがプラン選択ページのメインコンポーネントである | E-01 (424行目), E-02 (6, 28行目) | ○ |
| C-02 | 未認証時はサインインページにリダイレクトされる | E-01 (432-439行目) | ○ |
| C-03 | 無料会員はUpgradePlanSectionを表示 | E-01 (387-393行目) | ○ |
| C-04 | 有料会員はChangePlanSectionを表示 | E-01 (396-403行目) | ○ |
| C-05 | Complimentary会員はアップグレードセクションを表示 | E-01 (387行目 isComplimentaryMember条件) | ○ |
| C-06 | プラン選択でcheckoutPlanアクションが呼ばれる | E-01 (508行目) | ○ |
| C-07 | プラン変更でupdateSubscriptionアクションが呼ばれる | E-01 (505行目) | ○ |
| C-08 | キャンセルでcancelSubscriptionアクションが呼ばれる | E-01 (594-598行目) | ○ |
| C-09 | リテンションオファーがある場合はオファー画面を表示 | E-01 (547-555行目) | ○ |
| C-10 | オファー適用でapplyOfferアクションが呼ばれる | E-01 (575-578行目) | ○ |
| C-11 | キャンセル理由は最大500文字 | E-01 (218行目 maxLength="500") | ○ |
| C-12 | API checkoutPlanはStripe Checkoutセッションを作成 | E-04 (445-509行目) | ○ |
| C-13 | API updateSubscriptionはサブスクリプションを更新 | E-04 (631-656行目) | ○ |
| C-14 | API applyOfferはオファーを適用 | E-04 (679-701行目) | ○ |
| C-15 | getAvailablePricesで利用可能なプランを取得 | E-05 (575-615行目) | ○ |
| C-16 | getMemberSubscriptionで現在の購読情報を取得 | E-05 (39-51行目) | ○ |
| C-17 | isPaidMemberで有料会員判定 | E-05 (67-69行目) | ○ |
| C-18 | isComplimentaryMemberで招待会員判定 | E-05 (53-65行目) | ○ |
| C-19 | 画面遷移元はアカウントホームページ | E-07 (Portal遷移図) | ○ |
| C-20 | 機能No.15 Tier管理が主機能 | E-06 (81行目) | ○ |
| C-21 | 機能No.14 Stripe連携が補助機能 | E-06 (81行目) | ○ |
| C-22 | 機能No.71 Portalが補助機能 | E-06 (81行目) | ○ |
| C-23 | URLは#/portal/accountPlan | E-02 (28行目 accountPlan: AccountPlanPage) | ○ |
| C-24 | 確認画面でshowConfirmation状態を使用 | E-01 (396, 531-536行目) | ○ |
| C-25 | members_stripe_customers_subscriptionsテーブルを更新 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- データベーステーブル構造の詳細情報
  - 候補：`ghost/core/core/server/data/schema/` / StripeService実装 / データベースマイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック、画面遷移
- 0: 低リスク - API呼び出し処理
- 1: 中リスク - データベース更新仕様（バックエンド実装との整合性要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] AccountPlanPageコンポーネントの構造が設計書と一致しているか確認
- [ ] 会員種別による表示分岐が正しく記載されているか確認
- [ ] API呼び出しパスが実際のバックエンド実装と一致しているか確認
- [ ] データベース更新仕様がStripeサービス実装と整合しているか確認
