---
generated_at: 2026-01-29 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-ニュースレター選択ページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/newsletter-selection-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/pages.js` - ページルーティング定義
- E-03: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-04: `apps/portal/src/utils/api.js` - API通信処理
- E-05: `apps/portal/src/utils/helpers.js` - ヘルパー関数群
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NewsletterSelectionPageがニュースレター選択ページのメインコンポーネントである | E-01 (66行目), E-02 (10, 31行目) | ○ |
| C-02 | pageDataとonBackをpropsで受け取る | E-01 (66行目) | ○ |
| C-03 | デフォルトでsubscribe_on_signup=trueのニュースレターが選択 | E-01 (69-71行目) | ○ |
| C-04 | 有料限定ニュースレターはロックアイコン表示 | E-01 (13-24行目 newsletter.paid条件) | ○ |
| C-05 | ロックアイコンのツールチップテキスト | E-01 (21行目) | ○ |
| C-06 | Continueボタンでsignupアクション実行 | E-01 (114行目) | ○ |
| C-07 | signupに渡すデータ構造（name, email, plan, phonenumber, newsletters, offerId） | E-01 (113-114行目) | ○ |
| C-08 | newslettersはidとnameのみを抽出 | E-01 (107-112行目) | ○ |
| C-09 | "Choose a different plan"でonBack実行 | E-01 (126-127行目) | ○ |
| C-10 | hasOnlyFreePlan時は"Choose a different plan"非表示 | E-01 (121-131行目) | ○ |
| C-11 | action === 'signup:running'でisRunning=true | E-01 (75-77行目) | ○ |
| C-12 | action === 'signup:failed'でRetryラベル | E-01 (80-82行目) | ○ |
| C-13 | Switchトグルでニュースレター選択状態を更新 | E-01 (33-44行目) | ○ |
| C-14 | ページタイトルは"Choose your newsletters" | E-01 (90行目) | ○ |
| C-15 | Continueボタンラベルは"Continue" | E-01 (78行目) | ○ |
| C-16 | 機能No.20 ニュースレター管理が主機能 | E-06 (84行目) | ○ |
| C-17 | 機能No.71 Portalが補助機能 | E-06 (84行目) | ○ |
| C-18 | URLは#/portal/signupNewsletter | E-02 (31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック
- 0: 低リスク - ニュースレター選択処理
- 0: 低リスク - サインアップフロー連携

## 6) レビュアーチェックリスト（最小）
- [ ] NewsletterSelectionPageコンポーネントの構造が設計書と一致しているか確認
- [ ] サインアップアクションに渡すデータが正しく記載されているか確認
- [ ] 有料限定ニュースレターの表示制御が正しいか確認
