---
generated_at: 2026-01-29 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-マジックリンクページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/magic-link-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/pages.js` - ページルーティング定義
- E-03: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-04: `apps/portal/src/utils/api.js` - API通信処理
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MagicLinkPageがマジックリンクページのメインコンポーネントである | E-01 (80行目), E-02 (4, 33行目) | ○ |
| C-02 | stateにotc, errors, isFocusedを持つ | E-01 (83-89行目) | ○ |
| C-03 | ページタイトルは"Now check your email!" | E-01 (130行目) | ○ |
| C-04 | OTC有効時signin用メッセージ | E-01 (100行目) | ○ |
| C-05 | OTC無効時signin用メッセージ | E-01 (101行目) | ○ |
| C-06 | signup時のメッセージ | E-01 (103行目) | ○ |
| C-07 | otcRefでOTCフォーム表示判定 | E-01 (303行目) | ○ |
| C-08 | OTC入力は数字のみ許可 | E-01 (227行目 numericValue) | ○ |
| C-09 | 最大6文字 | E-01 (267行目 maxLength={6}) | ○ |
| C-10 | 6桁入力時に自動送信 | E-01 (231-233行目) | ○ |
| C-11 | doVerifyOTCでverifyOTCアクション実行 | E-01 (214行目) | ○ |
| C-12 | 空入力時"Enter code above"エラー | E-01 (199行目) | ○ |
| C-13 | Continueボタンラベル | E-01 (291行目) | ○ |
| C-14 | 検証中"Verifying..."ラベル | E-01 (291行目) | ○ |
| C-15 | Sniper Links判定 | E-01 (167行目 site.labs?.sniperlinks) | ○ |
| C-16 | Android Chrome判定でSniper Links分岐 | E-01 (171行目) | ○ |
| C-17 | "Open email"ボタン | E-01 (173行目) | ○ |
| C-18 | "Close"ボタン（OTC無効時） | E-01 (182行目) | ○ |
| C-19 | "Back to Log in"リンク | E-01 (155行目) | ○ |
| C-20 | api.member.verifyOTCでPOST | E-04 (328-355行目) | ○ |
| C-21 | 機能No.9 メンバー認証が主機能 | E-05 (86行目) | ○ |
| C-22 | 機能No.71 Portalが補助機能 | E-05 (86行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック
- 0: 低リスク - OTC入力・検証処理
- 0: 低リスク - Sniper Links機能

## 6) レビュアーチェックリスト（最小）
- [ ] MagicLinkPageコンポーネントの構造が設計書と一致しているか確認
- [ ] OTC入力の自動送信ロジックが正しいか確認
- [ ] lastPage/otcRefに応じたメッセージ表示が正しいか確認
