---
generated_at: 2026-01-29 12:30:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-オファーページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `apps/portal/src/components/pages/offer-page.js` - メインページコンポーネント
- E-02: `apps/portal/src/pages.js` - ページルーティング定義
- E-03: `apps/portal/src/app-context.js` - アプリケーションコンテキスト
- E-04: `apps/portal/src/utils/api.js` - API通信処理
- E-05: `apps/portal/src/utils/helpers.js` - ヘルパー関数群
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OfferPageがオファーページのメインコンポーネントである | E-01 (155行目), E-02 (9, 35行目) | ○ |
| C-02 | stateにname, email, showNewsletterSelection, termsCheckboxCheckedを持つ | E-01 (158-166行目) | ○ |
| C-03 | オファーがない場合はnullを返す | E-01 (652-654行目) | ○ |
| C-04 | 商品がない場合はnullを返す | E-01 (656-658行目) | ○ |
| C-05 | getProductFromIdで商品取得 | E-01 (655行目), E-05 (473-476行目) | ○ |
| C-06 | オファータイプ fixed/percent/trial | E-01 (445-461行目) | ○ |
| C-07 | 割引ラベル "{amount} off" | E-01 (447-449, 460行目) | ○ |
| C-08 | トライアルラベル "{amount} days free" | E-01 (454-456行目) | ○ |
| C-09 | オファー期間 once/forever/repeating | E-01 (543-557行目) | ○ |
| C-10 | getOriginalPriceで元価格取得 | E-01 (484-488行目) | ○ |
| C-11 | getUpdatedPriceで割引後価格計算 | E-01 (490-502行目) | ○ |
| C-12 | トライアル時は元価格取り消し線非表示 | E-01 (606-609行目) | ○ |
| C-13 | ログイン済みで入力フィールド無効化 | E-01 (190, 207行目 disabled: !!member) | ○ |
| C-14 | portal_signup_checkbox_requiredで利用規約必須 | E-01 (170-171行目, 245行目) | ○ |
| C-15 | hasMultipleNewslettersでニュースレター選択画面分岐 | E-01 (300-305行目) | ○ |
| C-16 | signupアクションにofferId渡す | E-01 (307行目) | ○ |
| C-17 | Continueボタンラベル | E-01 (383行目) | ○ |
| C-18 | トライアル時 "Start {amount}-day free trial" | E-01 (386行目) | ○ |
| C-19 | 送信中 "Sending..." | E-01 (391行目) | ○ |
| C-20 | 失敗後 "Retry" | E-01 (396行目) | ○ |
| C-21 | サインインリンク "Already a member?" / "Sign in" | E-01 (424, 430行目) | ○ |
| C-22 | オファータイトル未設定時 "Black Friday" | E-01 (673行目) | ○ |
| C-23 | 商品名 + Monthly/Yearly | E-01 (577, 581, 623行目) | ○ |
| C-24 | renderBenefitsで特典表示 | E-01 (464-482行目) | ○ |
| C-25 | 機能No.16 オファー管理が主機能 | E-06 (87行目) | ○ |
| C-26 | 機能No.14 Stripe連携、No.71 Portalが補助機能 | E-06 (87行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI表示ロジック
- 0: 低リスク - オファータイプによる表示分岐
- 0: 低リスク - 価格計算ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] OfferPageコンポーネントの構造が設計書と一致しているか確認
- [ ] オファータイプ（fixed/percent/trial）による表示分岐が正しいか確認
- [ ] 価格計算ロジック（getUpdatedPrice）が正しいか確認
- [ ] ニュースレター選択画面への遷移条件が正しいか確認
